#region References

using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using System.Text;
using gov.va.med.vbecs.Common;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmEditUnitProcessing
	/// </summary>
	public class FrmEditUnitProcessing : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		/// <summary>
		/// Efficiently store antigen types (NEG or POS)
		/// </summary>
		private const string _antigenTypeNeg = "NEG";
		private const string _antigenTypePos = "POS";

		/// <summary>
		/// Store original value here so we can   
		/// see if the tests have been updated
		/// </summary>
		private string _cmvTestOrigTestId;

		/// <summary>
		/// Store original value here so we can   
		/// see if the tests have been updated
		/// </summary>
		private string _scTestOrigTestId;

		/// <summary>
		/// Used by the Antigen Typing and ABO/Rh
		/// tabs to determine if the isDirty flag
		/// needs to be re-set
		/// </summary>
		private bool _isDirtyTemp;

		/// <summary>
		/// These fields are used (in the Ok_Clicked) to determine 
		/// if the corresponding values were changed and need to be
		/// updated on the database.
		/// </summary>
		private bool _originalVolumeChanged;
		private bool _discardedPlasmaVolumeChanged;
		private bool _testingStatusIdChanged;
		private bool _biohazardousWarningIndicatorChanged;
		private bool _restrictedPatientChanged;

		/// <summary>
		/// Is the current form in the process of loading?
		/// </summary>
		private bool _isLoading = false;

		/// <summary>
		/// Is the current form in the process of clearing?
		/// </summary>
		private bool _isClearing = false;

		/// <summary>
		/// Current blood unit
		/// </summary>
		private int _brokenFormRulesCount;

		/// <summary>
		/// Current blood unit
		/// </summary>
		private BOL.BloodUnit _bloodUnit;

		/// <summary>
		/// Abo/Rh Confirmation tests for the current blood unit
		/// </summary>
		private ArrayList _aboRhConfirmationTests;

		/// <summary>
		/// Antigen Typing tests for the current blood unit
		/// </summary>
		private ArrayList _antigenTypingTests;

		/// <summary>
		/// Testing statuses for Disease Marker Testing dropdown
		/// </summary>
		private ArrayList _alTestingStatusList;

		/// <summary>
		/// Antigens assigned to the blood unit. Used during inactivation.
		/// </summary>
		private ArrayList _bloodUnitAntigens;

		/// <summary>
		/// Checked antigens which have values that 
		/// are conflicting with tested values 
		/// </summary>
		private ArrayList _invalidAntigens;

		/// <summary>
		/// Stores a map of BloodTestTypeId to AntigenTypeId
		/// </summary>
		private static Hashtable _antigenTestMap;

		private Common.WorkloadProcessID _workloadAntigenTestingProcessId = Common.WorkloadProcessID.Unknown;

		#endregion

		#region Properties

		/// <summary>
		/// BrokenFormRulesCount
		/// </summary>
		private int BrokenFormRulesCount
		{
			get 
			{
				return this._brokenFormRulesCount;
			}
			set
			{
				if(value >= 0)
				{
					this._brokenFormRulesCount = value;
				}
				else
				{
					this._brokenFormRulesCount = 0;
				}
			}
		}

		#endregion

		#region Form Controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private gov.va.med.vbecs.GUI.controls.SpecialTesting specialTesting1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestingStatus;
		private System.Windows.Forms.Label lblDonationType;
		private System.Windows.Forms.PictureBox picBiohazard;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.TabControl tabEditUnit;
		private System.Windows.Forms.TabPage pageUnitInformation;
		private System.Windows.Forms.TabPage pageAntigenTyping;
		private System.Windows.Forms.TabPage pageABORhConfirmation;
		private System.Windows.Forms.ListView lvAntigenTyping;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnInvalidateAntigenTyping;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnInvalidateABORhConfirmation;
		private System.Windows.Forms.ListView lvABORhConfirmation;
		private System.Windows.Forms.GroupBox grpRestrictions;
		private System.Windows.Forms.Label lblTestingStatus;
		private System.Windows.Forms.TextBox txtDonationType;
		private System.Windows.Forms.GroupBox grpVolume;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updDiscardedPlasmaVolume;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updVolume;
		private System.Windows.Forms.Label lblDiscardedPlasmaVolume;
		private System.Windows.Forms.Label lblUnitVolume;
		private System.Windows.Forms.GroupBox grpBiohazardous;
		private System.Windows.Forms.CheckBox cbBiohazardous;
		private System.Windows.Forms.GroupBox grpABORhConfirmation;
		private System.Windows.Forms.Label lblAntiA;
		private System.Windows.Forms.TextBox txtAntiA;
		private System.Windows.Forms.TextBox txtAntiB;
		private System.Windows.Forms.Label lblAntiB;
		private System.Windows.Forms.TextBox txtAntiAB;
		private System.Windows.Forms.Label lblAntiAB;
		private System.Windows.Forms.TextBox txtDControl;
		private System.Windows.Forms.Label lblDControl;
		private System.Windows.Forms.TextBox txtAntiD;
		private System.Windows.Forms.Label lblAntiD;
		private System.Windows.Forms.TextBox txtABOComment;
		private System.Windows.Forms.Label lblABOComment;
		private System.Windows.Forms.TextBox txtABOInterpretation;
		private System.Windows.Forms.Label lblABOInterpretation;
		private System.Windows.Forms.TextBox txtRhComment;
		private System.Windows.Forms.Label lblRhComment;
		private System.Windows.Forms.TextBox txtRhInterpretation;
		private System.Windows.Forms.Label lblRhInterpretation;
		private System.Windows.Forms.GroupBox grpAntigenTyping;
		private System.Windows.Forms.TextBox txtAntigenTypingComment;
		private System.Windows.Forms.Label lblAntigenTypingComment;
		private System.Windows.Forms.TextBox txtAntigenTypingInterpretation;
		private System.Windows.Forms.Label lblAntigenTypingInterpretation;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.TextBox txtAntiserum;
		private System.Windows.Forms.Label lblAntiserum;
		private System.Windows.Forms.TextBox txtCC;
		private System.Windows.Forms.Label lblCC;
		private System.Windows.Forms.TextBox txtAHG;
		private System.Windows.Forms.Label lblAHG;
		private System.Windows.Forms.TextBox txt37C;
		private System.Windows.Forms.Label lbl37C;
		private System.Windows.Forms.TextBox txtRT;
		private System.Windows.Forms.Label lblRT;
		private System.Windows.Forms.TextBox txtIS;
		private System.Windows.Forms.Label lblIS;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnInactivateUnit;
		private System.Windows.Forms.GroupBox grpInvalidateTyping;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox grpInvalidateConfirmation;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label lblRestrictedPatient;
		private System.Windows.Forms.Button btnSelectPatient;
		private System.Windows.Forms.TextBox txtRestrictedPatient;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private System.Windows.Forms.GroupBox grpRestrictedFor;
		private System.Windows.Forms.TextBox txtAboRhInactivateComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbAboRhInactivateComment;
		private System.Windows.Forms.TextBox txtAntigenInactivateComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbAntigenInactivateComment;
		private System.Windows.Forms.Label lblAboRhConfirmationCommentDetails;
		private System.Windows.Forms.Label lblAntigenTypingCommentDetails;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmEditUnitProcessing()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC070EditUnitProcessing;

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus;
			//
			this._invalidAntigens = new ArrayList();
		}

		/// <summary>
		/// Load the map of BloodTestTypeId to AntigenTypeId
		/// </summary>
		static FrmEditUnitProcessing()
		{
			DataTable antigenTest = AntibodyType.GetAntigenTest();
			//
			_antigenTestMap = new Hashtable(antigenTest.Rows.Count);
			for (int idx = 0; idx < antigenTest.Rows.Count; idx++)
			{
				_antigenTestMap.Add(antigenTest.Rows[idx]["BloodTestTypeId"], antigenTest.Rows[idx]["AntigenTypeId"]);
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmEditUnitProcessing));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.tabEditUnit = new System.Windows.Forms.TabControl();
			this.pageUnitInformation = new System.Windows.Forms.TabPage();
			this.grpVolume = new System.Windows.Forms.GroupBox();
			this.updDiscardedPlasmaVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.updVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblDiscardedPlasmaVolume = new System.Windows.Forms.Label();
			this.lblUnitVolume = new System.Windows.Forms.Label();
			this.specialTesting1 = new gov.va.med.vbecs.GUI.controls.SpecialTesting();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpRestrictedFor = new System.Windows.Forms.GroupBox();
			this.lblRestrictedPatient = new System.Windows.Forms.Label();
			this.btnSelectPatient = new System.Windows.Forms.Button();
			this.txtRestrictedPatient = new System.Windows.Forms.TextBox();
			this.grpRestrictions = new System.Windows.Forms.GroupBox();
			this.txtDonationType = new System.Windows.Forms.TextBox();
			this.lblDonationType = new System.Windows.Forms.Label();
			this.cmbTestingStatus = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblTestingStatus = new System.Windows.Forms.Label();
			this.grpBiohazardous = new System.Windows.Forms.GroupBox();
			this.picBiohazard = new System.Windows.Forms.PictureBox();
			this.cbBiohazardous = new System.Windows.Forms.CheckBox();
			this.pageABORhConfirmation = new System.Windows.Forms.TabPage();
			this.grpInvalidateConfirmation = new System.Windows.Forms.GroupBox();
			this.txtAboRhInactivateComment = new System.Windows.Forms.TextBox();
			this.lblAboRhConfirmationCommentDetails = new System.Windows.Forms.Label();
			this.cmbAboRhInactivateComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.label4 = new System.Windows.Forms.Label();
			this.btnInvalidateABORhConfirmation = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpABORhConfirmation = new System.Windows.Forms.GroupBox();
			this.txtRhComment = new System.Windows.Forms.TextBox();
			this.lblRhComment = new System.Windows.Forms.Label();
			this.txtRhInterpretation = new System.Windows.Forms.TextBox();
			this.lblRhInterpretation = new System.Windows.Forms.Label();
			this.txtABOComment = new System.Windows.Forms.TextBox();
			this.lblABOComment = new System.Windows.Forms.Label();
			this.txtABOInterpretation = new System.Windows.Forms.TextBox();
			this.lblABOInterpretation = new System.Windows.Forms.Label();
			this.txtDControl = new System.Windows.Forms.TextBox();
			this.lblDControl = new System.Windows.Forms.Label();
			this.txtAntiD = new System.Windows.Forms.TextBox();
			this.lblAntiD = new System.Windows.Forms.Label();
			this.txtAntiAB = new System.Windows.Forms.TextBox();
			this.lblAntiAB = new System.Windows.Forms.Label();
			this.txtAntiB = new System.Windows.Forms.TextBox();
			this.lblAntiB = new System.Windows.Forms.Label();
			this.txtAntiA = new System.Windows.Forms.TextBox();
			this.lblAntiA = new System.Windows.Forms.Label();
			this.lvABORhConfirmation = new System.Windows.Forms.ListView();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.pageAntigenTyping = new System.Windows.Forms.TabPage();
			this.grpAntigenTyping = new System.Windows.Forms.GroupBox();
			this.txtCC = new System.Windows.Forms.TextBox();
			this.lblCC = new System.Windows.Forms.Label();
			this.txtAHG = new System.Windows.Forms.TextBox();
			this.lblAHG = new System.Windows.Forms.Label();
			this.txt37C = new System.Windows.Forms.TextBox();
			this.lbl37C = new System.Windows.Forms.Label();
			this.txtRT = new System.Windows.Forms.TextBox();
			this.lblRT = new System.Windows.Forms.Label();
			this.txtIS = new System.Windows.Forms.TextBox();
			this.lblIS = new System.Windows.Forms.Label();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.txtAntiserum = new System.Windows.Forms.TextBox();
			this.lblAntiserum = new System.Windows.Forms.Label();
			this.txtAntigenTypingComment = new System.Windows.Forms.TextBox();
			this.lblAntigenTypingComment = new System.Windows.Forms.Label();
			this.txtAntigenTypingInterpretation = new System.Windows.Forms.TextBox();
			this.lblAntigenTypingInterpretation = new System.Windows.Forms.Label();
			this.lvAntigenTyping = new System.Windows.Forms.ListView();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.grpInvalidateTyping = new System.Windows.Forms.GroupBox();
			this.txtAntigenInactivateComment = new System.Windows.Forms.TextBox();
			this.lblAntigenTypingCommentDetails = new System.Windows.Forms.Label();
			this.cmbAntigenInactivateComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.label1 = new System.Windows.Forms.Label();
			this.btnInvalidateAntigenTyping = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnInactivateUnit = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
			this.grpImage.SuspendLayout();
			this.tabEditUnit.SuspendLayout();
			this.pageUnitInformation.SuspendLayout();
			this.grpVolume.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updDiscardedPlasmaVolume)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updVolume)).BeginInit();
			this.grpRestrictedFor.SuspendLayout();
			this.grpRestrictions.SuspendLayout();
			this.grpBiohazardous.SuspendLayout();
			this.pageABORhConfirmation.SuspendLayout();
			this.grpInvalidateConfirmation.SuspendLayout();
			this.grpABORhConfirmation.SuspendLayout();
			this.pageAntigenTyping.SuspendLayout();
			this.grpAntigenTyping.SuspendLayout();
			this.grpInvalidateTyping.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(660, 30);
			this.vbecsLogo1.TabIndex = 4;
			this.vbecsLogo1.Title = "Edit Unit Information";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 392);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 6;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 334);
			this.grpImage.TabIndex = 5;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// tabEditUnit
			// 
			this.tabEditUnit.AccessibleDescription = "Unit Information";
			this.tabEditUnit.AccessibleName = "Unit Information";
			this.tabEditUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabEditUnit.Controls.Add(this.pageUnitInformation);
			this.tabEditUnit.Controls.Add(this.pageABORhConfirmation);
			this.tabEditUnit.Controls.Add(this.pageAntigenTyping);
			this.tabEditUnit.Location = new System.Drawing.Point(320, 36);
			this.tabEditUnit.Name = "tabEditUnit";
			this.tabEditUnit.SelectedIndex = 0;
			this.tabEditUnit.Size = new System.Drawing.Size(336, 330);
			this.tabEditUnit.TabIndex = 2;
			this.tabEditUnit.SelectedIndexChanged += new System.EventHandler(this.tabEditUnit_SelectedIndexChanged);
			// 
			// pageUnitInformation
			// 
			this.pageUnitInformation.Controls.Add(this.grpVolume);
			this.pageUnitInformation.Controls.Add(this.specialTesting1);
			this.pageUnitInformation.Controls.Add(this.btnOK);
			this.pageUnitInformation.Controls.Add(this.grpRestrictedFor);
			this.pageUnitInformation.Controls.Add(this.grpRestrictions);
			this.pageUnitInformation.Controls.Add(this.grpBiohazardous);
			this.pageUnitInformation.Location = new System.Drawing.Point(4, 23);
			this.pageUnitInformation.Name = "pageUnitInformation";
			this.pageUnitInformation.Size = new System.Drawing.Size(328, 303);
			this.pageUnitInformation.TabIndex = 0;
			this.pageUnitInformation.Text = "Unit Information";
			// 
			// grpVolume
			// 
			this.grpVolume.AccessibleDescription = "Volume";
			this.grpVolume.AccessibleName = "Volume";
			this.grpVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpVolume.Controls.Add(this.updDiscardedPlasmaVolume);
			this.grpVolume.Controls.Add(this.updVolume);
			this.grpVolume.Controls.Add(this.lblDiscardedPlasmaVolume);
			this.grpVolume.Controls.Add(this.lblUnitVolume);
			this.grpVolume.Location = new System.Drawing.Point(4, 4);
			this.grpVolume.Name = "grpVolume";
			this.grpVolume.Size = new System.Drawing.Size(182, 72);
			this.grpVolume.TabIndex = 0;
			this.grpVolume.TabStop = false;
			this.grpVolume.Text = "Volume";
			// 
			// updDiscardedPlasmaVolume
			// 
			this.updDiscardedPlasmaVolume.AccessibleDescription = "discarded plasma volume";
			this.updDiscardedPlasmaVolume.AccessibleName = "discarded plasma volume";
			this.updDiscardedPlasmaVolume.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updDiscardedPlasmaVolume.Location = new System.Drawing.Point(115, 40);
			this.updDiscardedPlasmaVolume.Maximum = new System.Decimal(new int[] {
																					 999,
																					 0,
																					 0,
																					 0});
			this.updDiscardedPlasmaVolume.Name = "updDiscardedPlasmaVolume";
			this.updDiscardedPlasmaVolume.Size = new System.Drawing.Size(48, 20);
			this.updDiscardedPlasmaVolume.TabIndex = 4;
			this.updDiscardedPlasmaVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updDiscardedPlasmaVolume.Value = new System.Decimal(new int[] {
																				   0,
																				   0,
																				   0,
																				   0});
			this.updDiscardedPlasmaVolume.TextChanged += new System.EventHandler(this.updDiscardedPlasmaVolume_ValueChanged);
			this.updDiscardedPlasmaVolume.Leave += new System.EventHandler(this.updDiscardedPlasmaVolume_Leave);
			this.updDiscardedPlasmaVolume.ValueChanged += new System.EventHandler(this.updDiscardedPlasmaVolume_ValueChanged);
			// 
			// updVolume
			// 
			this.updVolume.AccessibleDescription = "Unit Volume milliliters";
			this.updVolume.AccessibleName = "Unit Volume milliliters";
			this.updVolume.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.updVolume.Location = new System.Drawing.Point(115, 16);
			this.updVolume.Maximum = new System.Decimal(new int[] {
																	  2000,
																	  0,
																	  0,
																	  0});
			this.updVolume.Name = "updVolume";
			this.updVolume.Size = new System.Drawing.Size(48, 20);
			this.updVolume.TabIndex = 3;
			this.updVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updVolume.Value = new System.Decimal(new int[] {
																	0,
																	0,
																	0,
																	0});
			this.updVolume.TextChanged += new System.EventHandler(this.updVolume_ValueChanged);
			this.updVolume.Leave += new System.EventHandler(this.updVolume_Leave);
			this.updVolume.ValueChanged += new System.EventHandler(this.updVolume_ValueChanged);
			// 
			// lblDiscardedPlasmaVolume
			// 
			this.lblDiscardedPlasmaVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblDiscardedPlasmaVolume.Location = new System.Drawing.Point(8, 40);
			this.lblDiscardedPlasmaVolume.Name = "lblDiscardedPlasmaVolume";
			this.lblDiscardedPlasmaVolume.Size = new System.Drawing.Size(122, 24);
			this.lblDiscardedPlasmaVolume.TabIndex = 2;
			this.lblDiscardedPlasmaVolume.Text = "Discarded Plasma Volume (mL)";
			this.lblDiscardedPlasmaVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblUnitVolume
			// 
			this.lblUnitVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblUnitVolume.Location = new System.Drawing.Point(8, 16);
			this.lblUnitVolume.Name = "lblUnitVolume";
			this.lblUnitVolume.Size = new System.Drawing.Size(118, 20);
			this.lblUnitVolume.TabIndex = 0;
			this.lblUnitVolume.Text = "Unit Volume (mL)";
			this.lblUnitVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// specialTesting1
			// 
			this.specialTesting1.AccessibleDescription = "special testing";
			this.specialTesting1.AccessibleName = "special testing";
			this.specialTesting1.AllowUpdate = true;
			this.specialTesting1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.specialTesting1.AntigensEnabled = true;
			this.specialTesting1.BloodUnitGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.specialTesting1.CmvEnabled = true;
			this.specialTesting1.CmvNegative = false;
			this.specialTesting1.DivisionCode = "";
			this.specialTesting1.IsDirty = false;
			this.specialTesting1.Location = new System.Drawing.Point(190, 4);
			this.specialTesting1.Name = "specialTesting1";
			this.specialTesting1.SickleCellEnabled = true;
			this.specialTesting1.SickleCellNegative = false;
			this.specialTesting1.Size = new System.Drawing.Size(136, 220);
			this.specialTesting1.TabIndex = 10;
			this.specialTesting1.AntigenUpdated += new System.EventHandler(this.specialTesting1_AntigenUpdated);
			this.specialTesting1.IsDirtyChanged += new System.EventHandler(this.specialTesting1_IsDirtyChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(250, 280);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 11;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// grpRestrictedFor
			// 
			this.grpRestrictedFor.AccessibleDescription = "restricted for";
			this.grpRestrictedFor.AccessibleName = "restricted for";
			this.grpRestrictedFor.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRestrictedFor.Controls.Add(this.lblRestrictedPatient);
			this.grpRestrictedFor.Controls.Add(this.btnSelectPatient);
			this.grpRestrictedFor.Controls.Add(this.txtRestrictedPatient);
			this.grpRestrictedFor.Location = new System.Drawing.Point(4, 228);
			this.grpRestrictedFor.Name = "grpRestrictedFor";
			this.grpRestrictedFor.Size = new System.Drawing.Size(322, 48);
			this.grpRestrictedFor.TabIndex = 4;
			this.grpRestrictedFor.TabStop = false;
			this.grpRestrictedFor.Text = "Restricted For";
			// 
			// lblRestrictedPatient
			// 
			this.lblRestrictedPatient.Location = new System.Drawing.Point(8, 20);
			this.lblRestrictedPatient.Name = "lblRestrictedPatient";
			this.lblRestrictedPatient.Size = new System.Drawing.Size(40, 16);
			this.lblRestrictedPatient.TabIndex = 0;
			this.lblRestrictedPatient.Text = "Patient";
			this.lblRestrictedPatient.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnSelectPatient
			// 
			this.btnSelectPatient.AccessibleDescription = "find";
			this.btnSelectPatient.AccessibleName = "find";
			this.btnSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectPatient.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSelectPatient.Location = new System.Drawing.Point(294, 20);
			this.btnSelectPatient.Name = "btnSelectPatient";
			this.btnSelectPatient.Size = new System.Drawing.Size(26, 20);
			this.btnSelectPatient.TabIndex = 9;
			this.btnSelectPatient.Text = "find";
			this.btnSelectPatient.Click += new System.EventHandler(this.btnSelectPatient_Click);
			// 
			// txtRestrictedPatient
			// 
			this.txtRestrictedPatient.AccessibleDescription = "patient";
			this.txtRestrictedPatient.AccessibleName = "patient";
			this.txtRestrictedPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRestrictedPatient.Location = new System.Drawing.Point(52, 20);
			this.txtRestrictedPatient.MaxLength = 30;
			this.txtRestrictedPatient.Name = "txtRestrictedPatient";
			this.txtRestrictedPatient.ReadOnly = true;
			this.txtRestrictedPatient.Size = new System.Drawing.Size(242, 20);
			this.txtRestrictedPatient.TabIndex = 8;
			this.txtRestrictedPatient.Text = "";
			// 
			// grpRestrictions
			// 
			this.grpRestrictions.AccessibleDescription = "donation details";
			this.grpRestrictions.AccessibleName = "donation details";
			this.grpRestrictions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRestrictions.Controls.Add(this.txtDonationType);
			this.grpRestrictions.Controls.Add(this.lblDonationType);
			this.grpRestrictions.Controls.Add(this.cmbTestingStatus);
			this.grpRestrictions.Controls.Add(this.lblTestingStatus);
			this.grpRestrictions.Location = new System.Drawing.Point(4, 80);
			this.grpRestrictions.Name = "grpRestrictions";
			this.grpRestrictions.Size = new System.Drawing.Size(182, 104);
			this.grpRestrictions.TabIndex = 1;
			this.grpRestrictions.TabStop = false;
			this.grpRestrictions.Text = "Donation Details";
			// 
			// txtDonationType
			// 
			this.txtDonationType.AccessibleDescription = "donation type";
			this.txtDonationType.AccessibleName = "donation type";
			this.txtDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDonationType.Location = new System.Drawing.Point(8, 32);
			this.txtDonationType.MaxLength = 30;
			this.txtDonationType.Name = "txtDonationType";
			this.txtDonationType.ReadOnly = true;
			this.txtDonationType.Size = new System.Drawing.Size(166, 20);
			this.txtDonationType.TabIndex = 5;
			this.txtDonationType.Text = "";
			// 
			// lblDonationType
			// 
			this.lblDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblDonationType.Location = new System.Drawing.Point(8, 16);
			this.lblDonationType.Name = "lblDonationType";
			this.lblDonationType.Size = new System.Drawing.Size(166, 16);
			this.lblDonationType.TabIndex = 0;
			this.lblDonationType.Text = "Donation Type";
			this.lblDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbTestingStatus
			// 
			this.cmbTestingStatus.AccessibleDescription = "disease marker testing";
			this.cmbTestingStatus.AccessibleName = "disease marker testing";
			this.cmbTestingStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbTestingStatus.DropDownWidth = 139;
			this.cmbTestingStatus.Interval = 500;
			this.cmbTestingStatus.Location = new System.Drawing.Point(8, 72);
			this.cmbTestingStatus.Name = "cmbTestingStatus";
			this.cmbTestingStatus.Size = new System.Drawing.Size(166, 22);
			this.cmbTestingStatus.TabIndex = 6;
			this.cmbTestingStatus.SelectedIndexChanged += new System.EventHandler(this.cmbTestingStatus_SelectedIndexChanged);
			// 
			// lblTestingStatus
			// 
			this.lblTestingStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblTestingStatus.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblTestingStatus.Location = new System.Drawing.Point(8, 56);
			this.lblTestingStatus.Name = "lblTestingStatus";
			this.lblTestingStatus.Size = new System.Drawing.Size(166, 16);
			this.lblTestingStatus.TabIndex = 2;
			this.lblTestingStatus.Text = "Disease Marker Testing";
			// 
			// grpBiohazardous
			// 
			this.grpBiohazardous.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpBiohazardous.Controls.Add(this.picBiohazard);
			this.grpBiohazardous.Controls.Add(this.cbBiohazardous);
			this.grpBiohazardous.Location = new System.Drawing.Point(4, 184);
			this.grpBiohazardous.Name = "grpBiohazardous";
			this.grpBiohazardous.Size = new System.Drawing.Size(182, 40);
			this.grpBiohazardous.TabIndex = 2;
			this.grpBiohazardous.TabStop = false;
			// 
			// picBiohazard
			// 
			this.picBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picBiohazard.Image")));
			this.picBiohazard.Location = new System.Drawing.Point(8, 12);
			this.picBiohazard.Name = "picBiohazard";
			this.picBiohazard.Size = new System.Drawing.Size(24, 20);
			this.picBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picBiohazard.TabIndex = 33;
			this.picBiohazard.TabStop = false;
			// 
			// cbBiohazardous
			// 
			this.cbBiohazardous.AccessibleDescription = "biohazardous";
			this.cbBiohazardous.AccessibleName = "biohazardous";
			this.cbBiohazardous.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbBiohazardous.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbBiohazardous.ImageAlign = System.Drawing.ContentAlignment.TopCenter;
			this.cbBiohazardous.Location = new System.Drawing.Point(32, 12);
			this.cbBiohazardous.Name = "cbBiohazardous";
			this.cbBiohazardous.Size = new System.Drawing.Size(146, 20);
			this.cbBiohazardous.TabIndex = 7;
			this.cbBiohazardous.Text = "&Biohazardous?";
			this.cbBiohazardous.CheckedChanged += new System.EventHandler(this.cbBiohazardous_CheckedChanged);
			// 
			// pageABORhConfirmation
			// 
			this.pageABORhConfirmation.Controls.Add(this.grpInvalidateConfirmation);
			this.pageABORhConfirmation.Controls.Add(this.grpABORhConfirmation);
			this.pageABORhConfirmation.Controls.Add(this.lvABORhConfirmation);
			this.pageABORhConfirmation.Location = new System.Drawing.Point(4, 23);
			this.pageABORhConfirmation.Name = "pageABORhConfirmation";
			this.pageABORhConfirmation.Size = new System.Drawing.Size(328, 303);
			this.pageABORhConfirmation.TabIndex = 2;
			this.pageABORhConfirmation.Text = "ABO/Rh Confirmation";
			// 
			// grpInvalidateConfirmation
			// 
			this.grpInvalidateConfirmation.AccessibleDescription = "invalidate";
			this.grpInvalidateConfirmation.AccessibleName = "invalidate";
			this.grpInvalidateConfirmation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInvalidateConfirmation.Controls.Add(this.txtAboRhInactivateComment);
			this.grpInvalidateConfirmation.Controls.Add(this.lblAboRhConfirmationCommentDetails);
			this.grpInvalidateConfirmation.Controls.Add(this.cmbAboRhInactivateComment);
			this.grpInvalidateConfirmation.Controls.Add(this.label4);
			this.grpInvalidateConfirmation.Controls.Add(this.btnInvalidateABORhConfirmation);
			this.grpInvalidateConfirmation.Location = new System.Drawing.Point(4, 192);
			this.grpInvalidateConfirmation.Name = "grpInvalidateConfirmation";
			this.grpInvalidateConfirmation.Size = new System.Drawing.Size(322, 104);
			this.grpInvalidateConfirmation.TabIndex = 2;
			this.grpInvalidateConfirmation.TabStop = false;
			this.grpInvalidateConfirmation.Text = "Invalidate";
			// 
			// txtAboRhInactivateComment
			// 
			this.txtAboRhInactivateComment.AccessibleDescription = "Details";
			this.txtAboRhInactivateComment.AccessibleName = "Details";
			this.txtAboRhInactivateComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAboRhInactivateComment.Location = new System.Drawing.Point(76, 40);
			this.txtAboRhInactivateComment.MaxLength = 255;
			this.txtAboRhInactivateComment.Multiline = true;
			this.txtAboRhInactivateComment.Name = "txtAboRhInactivateComment";
			this.txtAboRhInactivateComment.Size = new System.Drawing.Size(236, 32);
			this.txtAboRhInactivateComment.TabIndex = 3;
			this.txtAboRhInactivateComment.Text = "";
			this.txtAboRhInactivateComment.TextChanged += new System.EventHandler(this.txtAboRhInactivateComment_TextChanged);
			// 
			// lblAboRhConfirmationCommentDetails
			// 
			this.lblAboRhConfirmationCommentDetails.Location = new System.Drawing.Point(8, 40);
			this.lblAboRhConfirmationCommentDetails.Name = "lblAboRhConfirmationCommentDetails";
			this.lblAboRhConfirmationCommentDetails.Size = new System.Drawing.Size(68, 20);
			this.lblAboRhConfirmationCommentDetails.TabIndex = 2;
			this.lblAboRhConfirmationCommentDetails.Text = "Details";
			this.lblAboRhConfirmationCommentDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbAboRhInactivateComment
			// 
			this.cmbAboRhInactivateComment.AccessibleDescription = "comment";
			this.cmbAboRhInactivateComment.AccessibleName = "comment";
			this.cmbAboRhInactivateComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbAboRhInactivateComment.DropDownWidth = 139;
			this.cmbAboRhInactivateComment.Interval = 500;
			this.cmbAboRhInactivateComment.Location = new System.Drawing.Point(76, 16);
			this.cmbAboRhInactivateComment.Name = "cmbAboRhInactivateComment";
			this.cmbAboRhInactivateComment.Size = new System.Drawing.Size(238, 20);
			this.cmbAboRhInactivateComment.TabIndex = 1;
			this.cmbAboRhInactivateComment.SelectedIndexChanged += new System.EventHandler(this.cmbAboRhInactivateComment_SelectedIndexChanged);
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 16);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(68, 20);
			this.label4.TabIndex = 0;
			this.label4.Text = "Comment*";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnInvalidateABORhConfirmation
			// 
			this.btnInvalidateABORhConfirmation.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnInvalidateABORhConfirmation.EnabledButton = false;
			this.btnInvalidateABORhConfirmation.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnInvalidateABORhConfirmation.Image = ((System.Drawing.Image)(resources.GetObject("btnInvalidateABORhConfirmation.Image")));
			this.btnInvalidateABORhConfirmation.Location = new System.Drawing.Point(148, 76);
			this.btnInvalidateABORhConfirmation.Name = "btnInvalidateABORhConfirmation";
			this.btnInvalidateABORhConfirmation.Size = new System.Drawing.Size(164, 23);
			this.btnInvalidateABORhConfirmation.TabIndex = 4;
			this.btnInvalidateABORhConfirmation.Click += new System.EventHandler(this.btnInvalidateABORhConfirmation_Click);
			this.btnInvalidateABORhConfirmation.MouseHover += new System.EventHandler(this.btnInvalidateABORhConfirmation_MouseHover);
			// 
			// grpABORhConfirmation
			// 
			this.grpABORhConfirmation.AccessibleDescription = "Selected Test Details";
			this.grpABORhConfirmation.AccessibleName = "Selected Test Details";
			this.grpABORhConfirmation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpABORhConfirmation.Controls.Add(this.txtRhComment);
			this.grpABORhConfirmation.Controls.Add(this.lblRhComment);
			this.grpABORhConfirmation.Controls.Add(this.txtRhInterpretation);
			this.grpABORhConfirmation.Controls.Add(this.lblRhInterpretation);
			this.grpABORhConfirmation.Controls.Add(this.txtABOComment);
			this.grpABORhConfirmation.Controls.Add(this.lblABOComment);
			this.grpABORhConfirmation.Controls.Add(this.txtABOInterpretation);
			this.grpABORhConfirmation.Controls.Add(this.lblABOInterpretation);
			this.grpABORhConfirmation.Controls.Add(this.txtDControl);
			this.grpABORhConfirmation.Controls.Add(this.lblDControl);
			this.grpABORhConfirmation.Controls.Add(this.txtAntiD);
			this.grpABORhConfirmation.Controls.Add(this.lblAntiD);
			this.grpABORhConfirmation.Controls.Add(this.txtAntiAB);
			this.grpABORhConfirmation.Controls.Add(this.lblAntiAB);
			this.grpABORhConfirmation.Controls.Add(this.txtAntiB);
			this.grpABORhConfirmation.Controls.Add(this.lblAntiB);
			this.grpABORhConfirmation.Controls.Add(this.txtAntiA);
			this.grpABORhConfirmation.Controls.Add(this.lblAntiA);
			this.grpABORhConfirmation.Location = new System.Drawing.Point(4, 88);
			this.grpABORhConfirmation.Name = "grpABORhConfirmation";
			this.grpABORhConfirmation.Size = new System.Drawing.Size(322, 104);
			this.grpABORhConfirmation.TabIndex = 1;
			this.grpABORhConfirmation.TabStop = false;
			this.grpABORhConfirmation.Text = "Selected Test Details";
			// 
			// txtRhComment
			// 
			this.txtRhComment.AccessibleDescription = "comment";
			this.txtRhComment.AccessibleName = "comment";
			this.txtRhComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRhComment.Location = new System.Drawing.Point(156, 76);
			this.txtRhComment.Name = "txtRhComment";
			this.txtRhComment.ReadOnly = true;
			this.txtRhComment.Size = new System.Drawing.Size(164, 20);
			this.txtRhComment.TabIndex = 17;
			this.txtRhComment.Text = "";
			// 
			// lblRhComment
			// 
			this.lblRhComment.Location = new System.Drawing.Point(104, 76);
			this.lblRhComment.Name = "lblRhComment";
			this.lblRhComment.Size = new System.Drawing.Size(56, 20);
			this.lblRhComment.TabIndex = 16;
			this.lblRhComment.Text = "Comment";
			this.lblRhComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtRhInterpretation
			// 
			this.txtRhInterpretation.AccessibleDescription = "R H";
			this.txtRhInterpretation.AccessibleName = "R H";
			this.txtRhInterpretation.Location = new System.Drawing.Point(48, 76);
			this.txtRhInterpretation.Name = "txtRhInterpretation";
			this.txtRhInterpretation.ReadOnly = true;
			this.txtRhInterpretation.Size = new System.Drawing.Size(48, 20);
			this.txtRhInterpretation.TabIndex = 15;
			this.txtRhInterpretation.Text = "";
			// 
			// lblRhInterpretation
			// 
			this.lblRhInterpretation.Location = new System.Drawing.Point(8, 76);
			this.lblRhInterpretation.Name = "lblRhInterpretation";
			this.lblRhInterpretation.Size = new System.Drawing.Size(44, 20);
			this.lblRhInterpretation.TabIndex = 14;
			this.lblRhInterpretation.Text = "Rh";
			this.lblRhInterpretation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtABOComment
			// 
			this.txtABOComment.AccessibleDescription = "comment";
			this.txtABOComment.AccessibleName = "comment";
			this.txtABOComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtABOComment.Location = new System.Drawing.Point(156, 52);
			this.txtABOComment.Name = "txtABOComment";
			this.txtABOComment.ReadOnly = true;
			this.txtABOComment.Size = new System.Drawing.Size(164, 20);
			this.txtABOComment.TabIndex = 13;
			this.txtABOComment.Text = "";
			// 
			// lblABOComment
			// 
			this.lblABOComment.Location = new System.Drawing.Point(104, 52);
			this.lblABOComment.Name = "lblABOComment";
			this.lblABOComment.Size = new System.Drawing.Size(56, 20);
			this.lblABOComment.TabIndex = 12;
			this.lblABOComment.Text = "Comment";
			this.lblABOComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtABOInterpretation
			// 
			this.txtABOInterpretation.AccessibleDescription = "A B O";
			this.txtABOInterpretation.AccessibleName = "A B O";
			this.txtABOInterpretation.Location = new System.Drawing.Point(48, 52);
			this.txtABOInterpretation.Name = "txtABOInterpretation";
			this.txtABOInterpretation.ReadOnly = true;
			this.txtABOInterpretation.Size = new System.Drawing.Size(48, 20);
			this.txtABOInterpretation.TabIndex = 11;
			this.txtABOInterpretation.Text = "";
			// 
			// lblABOInterpretation
			// 
			this.lblABOInterpretation.Location = new System.Drawing.Point(8, 52);
			this.lblABOInterpretation.Name = "lblABOInterpretation";
			this.lblABOInterpretation.Size = new System.Drawing.Size(44, 20);
			this.lblABOInterpretation.TabIndex = 10;
			this.lblABOInterpretation.Text = "ABO";
			this.lblABOInterpretation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDControl
			// 
			this.txtDControl.AccessibleDescription = "D Control";
			this.txtDControl.AccessibleName = "D Control";
			this.txtDControl.Location = new System.Drawing.Point(264, 28);
			this.txtDControl.Name = "txtDControl";
			this.txtDControl.ReadOnly = true;
			this.txtDControl.Size = new System.Drawing.Size(56, 20);
			this.txtDControl.TabIndex = 9;
			this.txtDControl.Text = "";
			this.txtDControl.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblDControl
			// 
			this.lblDControl.Location = new System.Drawing.Point(264, 12);
			this.lblDControl.Name = "lblDControl";
			this.lblDControl.Size = new System.Drawing.Size(56, 20);
			this.lblDControl.TabIndex = 8;
			this.lblDControl.Text = "D Control";
			this.lblDControl.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtAntiD
			// 
			this.txtAntiD.AccessibleDescription = "anti D";
			this.txtAntiD.AccessibleName = "anti D";
			this.txtAntiD.Location = new System.Drawing.Point(200, 28);
			this.txtAntiD.Name = "txtAntiD";
			this.txtAntiD.ReadOnly = true;
			this.txtAntiD.Size = new System.Drawing.Size(56, 20);
			this.txtAntiD.TabIndex = 7;
			this.txtAntiD.Text = "";
			this.txtAntiD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblAntiD
			// 
			this.lblAntiD.Location = new System.Drawing.Point(200, 12);
			this.lblAntiD.Name = "lblAntiD";
			this.lblAntiD.Size = new System.Drawing.Size(56, 20);
			this.lblAntiD.TabIndex = 6;
			this.lblAntiD.Text = "Anti-D";
			this.lblAntiD.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtAntiAB
			// 
			this.txtAntiAB.AccessibleDescription = "ANTI A B";
			this.txtAntiAB.AccessibleName = "ANTI A B";
			this.txtAntiAB.Location = new System.Drawing.Point(136, 28);
			this.txtAntiAB.Name = "txtAntiAB";
			this.txtAntiAB.ReadOnly = true;
			this.txtAntiAB.Size = new System.Drawing.Size(56, 20);
			this.txtAntiAB.TabIndex = 5;
			this.txtAntiAB.Text = "";
			this.txtAntiAB.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblAntiAB
			// 
			this.lblAntiAB.Location = new System.Drawing.Point(136, 12);
			this.lblAntiAB.Name = "lblAntiAB";
			this.lblAntiAB.Size = new System.Drawing.Size(56, 20);
			this.lblAntiAB.TabIndex = 4;
			this.lblAntiAB.Text = "Anti-AB";
			this.lblAntiAB.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtAntiB
			// 
			this.txtAntiB.AccessibleDescription = "ANTI B";
			this.txtAntiB.AccessibleName = "ANTI B";
			this.txtAntiB.Location = new System.Drawing.Point(72, 28);
			this.txtAntiB.Name = "txtAntiB";
			this.txtAntiB.ReadOnly = true;
			this.txtAntiB.Size = new System.Drawing.Size(56, 20);
			this.txtAntiB.TabIndex = 3;
			this.txtAntiB.Text = "";
			this.txtAntiB.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblAntiB
			// 
			this.lblAntiB.Location = new System.Drawing.Point(72, 12);
			this.lblAntiB.Name = "lblAntiB";
			this.lblAntiB.Size = new System.Drawing.Size(56, 20);
			this.lblAntiB.TabIndex = 2;
			this.lblAntiB.Text = "Anti-B";
			this.lblAntiB.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtAntiA
			// 
			this.txtAntiA.AccessibleDescription = "ANTI A";
			this.txtAntiA.AccessibleName = "ANTI A";
			this.txtAntiA.Location = new System.Drawing.Point(8, 28);
			this.txtAntiA.Name = "txtAntiA";
			this.txtAntiA.ReadOnly = true;
			this.txtAntiA.Size = new System.Drawing.Size(56, 20);
			this.txtAntiA.TabIndex = 1;
			this.txtAntiA.Text = "";
			this.txtAntiA.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblAntiA
			// 
			this.lblAntiA.Location = new System.Drawing.Point(8, 12);
			this.lblAntiA.Name = "lblAntiA";
			this.lblAntiA.Size = new System.Drawing.Size(56, 20);
			this.lblAntiA.TabIndex = 0;
			this.lblAntiA.Text = "Anti-A";
			this.lblAntiA.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lvABORhConfirmation
			// 
			this.lvABORhConfirmation.AccessibleDescription = "A B O R H Confirmation";
			this.lvABORhConfirmation.AccessibleName = "A B O R H Confirmation";
			this.lvABORhConfirmation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvABORhConfirmation.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								  this.columnHeader4,
																								  this.columnHeader5,
																								  this.columnHeader6});
			this.lvABORhConfirmation.FullRowSelect = true;
			this.lvABORhConfirmation.HideSelection = false;
			this.lvABORhConfirmation.Location = new System.Drawing.Point(4, 4);
			this.lvABORhConfirmation.MultiSelect = false;
			this.lvABORhConfirmation.Name = "lvABORhConfirmation";
			this.lvABORhConfirmation.Size = new System.Drawing.Size(322, 84);
			this.lvABORhConfirmation.TabIndex = 0;
			this.lvABORhConfirmation.View = System.Windows.Forms.View.Details;
			this.lvABORhConfirmation.SelectedIndexChanged += new System.EventHandler(this.lvABORhConfirmation_SelectedIndexChanged);
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Date Tested";
			this.columnHeader4.Width = 120;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "ABO Interp.";
			this.columnHeader5.Width = 100;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Rh Interp.";
			this.columnHeader6.Width = 100;
			// 
			// pageAntigenTyping
			// 
			this.pageAntigenTyping.Controls.Add(this.grpAntigenTyping);
			this.pageAntigenTyping.Controls.Add(this.lvAntigenTyping);
			this.pageAntigenTyping.Controls.Add(this.grpInvalidateTyping);
			this.pageAntigenTyping.Location = new System.Drawing.Point(4, 23);
			this.pageAntigenTyping.Name = "pageAntigenTyping";
			this.pageAntigenTyping.Size = new System.Drawing.Size(328, 303);
			this.pageAntigenTyping.TabIndex = 1;
			this.pageAntigenTyping.Text = "Antigen Typing";
			// 
			// grpAntigenTyping
			// 
			this.grpAntigenTyping.AccessibleDescription = "Selected Test Details";
			this.grpAntigenTyping.AccessibleName = "Selected Test Details";
			this.grpAntigenTyping.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntigenTyping.Controls.Add(this.txtCC);
			this.grpAntigenTyping.Controls.Add(this.lblCC);
			this.grpAntigenTyping.Controls.Add(this.txtAHG);
			this.grpAntigenTyping.Controls.Add(this.lblAHG);
			this.grpAntigenTyping.Controls.Add(this.txt37C);
			this.grpAntigenTyping.Controls.Add(this.lbl37C);
			this.grpAntigenTyping.Controls.Add(this.txtRT);
			this.grpAntigenTyping.Controls.Add(this.lblRT);
			this.grpAntigenTyping.Controls.Add(this.txtIS);
			this.grpAntigenTyping.Controls.Add(this.lblIS);
			this.grpAntigenTyping.Controls.Add(this.txtLotNumber);
			this.grpAntigenTyping.Controls.Add(this.lblLotNumber);
			this.grpAntigenTyping.Controls.Add(this.txtAntiserum);
			this.grpAntigenTyping.Controls.Add(this.lblAntiserum);
			this.grpAntigenTyping.Controls.Add(this.txtAntigenTypingComment);
			this.grpAntigenTyping.Controls.Add(this.lblAntigenTypingComment);
			this.grpAntigenTyping.Controls.Add(this.txtAntigenTypingInterpretation);
			this.grpAntigenTyping.Controls.Add(this.lblAntigenTypingInterpretation);
			this.grpAntigenTyping.Location = new System.Drawing.Point(4, 88);
			this.grpAntigenTyping.Name = "grpAntigenTyping";
			this.grpAntigenTyping.Size = new System.Drawing.Size(322, 104);
			this.grpAntigenTyping.TabIndex = 1;
			this.grpAntigenTyping.TabStop = false;
			this.grpAntigenTyping.Text = "Selected Test Details";
			// 
			// txtCC
			// 
			this.txtCC.AccessibleDescription = "C C";
			this.txtCC.AccessibleName = "C C ";
			this.txtCC.Location = new System.Drawing.Point(264, 28);
			this.txtCC.Name = "txtCC";
			this.txtCC.ReadOnly = true;
			this.txtCC.Size = new System.Drawing.Size(56, 20);
			this.txtCC.TabIndex = 9;
			this.txtCC.Text = "";
			this.txtCC.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblCC
			// 
			this.lblCC.Location = new System.Drawing.Point(264, 12);
			this.lblCC.Name = "lblCC";
			this.lblCC.Size = new System.Drawing.Size(56, 20);
			this.lblCC.TabIndex = 8;
			this.lblCC.Text = "CC";
			this.lblCC.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtAHG
			// 
			this.txtAHG.AccessibleDescription = "A H G";
			this.txtAHG.AccessibleName = "A H G";
			this.txtAHG.Location = new System.Drawing.Point(200, 28);
			this.txtAHG.Name = "txtAHG";
			this.txtAHG.ReadOnly = true;
			this.txtAHG.Size = new System.Drawing.Size(56, 20);
			this.txtAHG.TabIndex = 7;
			this.txtAHG.Text = "";
			this.txtAHG.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblAHG
			// 
			this.lblAHG.Location = new System.Drawing.Point(200, 12);
			this.lblAHG.Name = "lblAHG";
			this.lblAHG.Size = new System.Drawing.Size(56, 20);
			this.lblAHG.TabIndex = 6;
			this.lblAHG.Text = "AHG";
			this.lblAHG.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txt37C
			// 
			this.txt37C.AccessibleDescription = "37 C";
			this.txt37C.AccessibleName = "37 C";
			this.txt37C.Location = new System.Drawing.Point(136, 28);
			this.txt37C.Name = "txt37C";
			this.txt37C.ReadOnly = true;
			this.txt37C.Size = new System.Drawing.Size(56, 20);
			this.txt37C.TabIndex = 5;
			this.txt37C.Text = "";
			this.txt37C.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lbl37C
			// 
			this.lbl37C.Location = new System.Drawing.Point(136, 12);
			this.lbl37C.Name = "lbl37C";
			this.lbl37C.Size = new System.Drawing.Size(56, 20);
			this.lbl37C.TabIndex = 4;
			this.lbl37C.Text = "37C";
			this.lbl37C.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtRT
			// 
			this.txtRT.AccessibleDescription = "R T";
			this.txtRT.AccessibleName = "R T";
			this.txtRT.Location = new System.Drawing.Point(72, 28);
			this.txtRT.Name = "txtRT";
			this.txtRT.ReadOnly = true;
			this.txtRT.Size = new System.Drawing.Size(56, 20);
			this.txtRT.TabIndex = 3;
			this.txtRT.Text = "";
			this.txtRT.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblRT
			// 
			this.lblRT.Location = new System.Drawing.Point(72, 12);
			this.lblRT.Name = "lblRT";
			this.lblRT.Size = new System.Drawing.Size(56, 20);
			this.lblRT.TabIndex = 2;
			this.lblRT.Text = "RT";
			this.lblRT.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtIS
			// 
			this.txtIS.AccessibleDescription = "I S";
			this.txtIS.AccessibleName = "I S";
			this.txtIS.Location = new System.Drawing.Point(8, 28);
			this.txtIS.Name = "txtIS";
			this.txtIS.ReadOnly = true;
			this.txtIS.Size = new System.Drawing.Size(56, 20);
			this.txtIS.TabIndex = 1;
			this.txtIS.Text = "";
			this.txtIS.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			// 
			// lblIS
			// 
			this.lblIS.Location = new System.Drawing.Point(8, 12);
			this.lblIS.Name = "lblIS";
			this.lblIS.Size = new System.Drawing.Size(56, 20);
			this.lblIS.TabIndex = 0;
			this.lblIS.Text = "IS";
			this.lblIS.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.AccessibleDescription = "lot number";
			this.txtLotNumber.AccessibleName = "lot number";
			this.txtLotNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtLotNumber.Location = new System.Drawing.Point(224, 52);
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.ReadOnly = true;
			this.txtLotNumber.Size = new System.Drawing.Size(96, 20);
			this.txtLotNumber.TabIndex = 13;
			this.txtLotNumber.Text = "";
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(164, 52);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(68, 20);
			this.lblLotNumber.TabIndex = 12;
			this.lblLotNumber.Text = "Lot Number";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtAntiserum
			// 
			this.txtAntiserum.AccessibleDescription = "Reagent";
			this.txtAntiserum.AccessibleName = "Reagent";
			this.txtAntiserum.Location = new System.Drawing.Point(76, 52);
			this.txtAntiserum.Name = "txtAntiserum";
			this.txtAntiserum.ReadOnly = true;
			this.txtAntiserum.Size = new System.Drawing.Size(84, 20);
			this.txtAntiserum.TabIndex = 11;
			this.txtAntiserum.Text = "";
			// 
			// lblAntiserum
			// 
			this.lblAntiserum.Location = new System.Drawing.Point(8, 52);
			this.lblAntiserum.Name = "lblAntiserum";
			this.lblAntiserum.Size = new System.Drawing.Size(56, 20);
			this.lblAntiserum.TabIndex = 10;
			this.lblAntiserum.Text = "Reagent";
			this.lblAntiserum.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtAntigenTypingComment
			// 
			this.txtAntigenTypingComment.AccessibleDescription = "comment";
			this.txtAntigenTypingComment.AccessibleName = "comment";
			this.txtAntigenTypingComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntigenTypingComment.Location = new System.Drawing.Point(184, 76);
			this.txtAntigenTypingComment.Name = "txtAntigenTypingComment";
			this.txtAntigenTypingComment.ReadOnly = true;
			this.txtAntigenTypingComment.Size = new System.Drawing.Size(136, 20);
			this.txtAntigenTypingComment.TabIndex = 17;
			this.txtAntigenTypingComment.Text = "";
			// 
			// lblAntigenTypingComment
			// 
			this.lblAntigenTypingComment.Location = new System.Drawing.Point(132, 76);
			this.lblAntigenTypingComment.Name = "lblAntigenTypingComment";
			this.lblAntigenTypingComment.Size = new System.Drawing.Size(56, 20);
			this.lblAntigenTypingComment.TabIndex = 16;
			this.lblAntigenTypingComment.Text = "Comment";
			this.lblAntigenTypingComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtAntigenTypingInterpretation
			// 
			this.txtAntigenTypingInterpretation.AccessibleDescription = "interpretation";
			this.txtAntigenTypingInterpretation.AccessibleName = "interpretation";
			this.txtAntigenTypingInterpretation.Location = new System.Drawing.Point(76, 76);
			this.txtAntigenTypingInterpretation.Name = "txtAntigenTypingInterpretation";
			this.txtAntigenTypingInterpretation.ReadOnly = true;
			this.txtAntigenTypingInterpretation.Size = new System.Drawing.Size(44, 20);
			this.txtAntigenTypingInterpretation.TabIndex = 15;
			this.txtAntigenTypingInterpretation.Text = "";
			// 
			// lblAntigenTypingInterpretation
			// 
			this.lblAntigenTypingInterpretation.Location = new System.Drawing.Point(8, 76);
			this.lblAntigenTypingInterpretation.Name = "lblAntigenTypingInterpretation";
			this.lblAntigenTypingInterpretation.Size = new System.Drawing.Size(72, 20);
			this.lblAntigenTypingInterpretation.TabIndex = 14;
			this.lblAntigenTypingInterpretation.Text = "Interpretation";
			this.lblAntigenTypingInterpretation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvAntigenTyping
			// 
			this.lvAntigenTyping.AccessibleDescription = "Antigen typing";
			this.lvAntigenTyping.AccessibleName = "Antigen typing";
			this.lvAntigenTyping.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAntigenTyping.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader2,
																							  this.columnHeader1,
																							  this.columnHeader3});
			this.lvAntigenTyping.FullRowSelect = true;
			this.lvAntigenTyping.HideSelection = false;
			this.lvAntigenTyping.Location = new System.Drawing.Point(4, 4);
			this.lvAntigenTyping.MultiSelect = false;
			this.lvAntigenTyping.Name = "lvAntigenTyping";
			this.lvAntigenTyping.Size = new System.Drawing.Size(322, 84);
			this.lvAntigenTyping.TabIndex = 0;
			this.lvAntigenTyping.View = System.Windows.Forms.View.Details;
			this.lvAntigenTyping.SelectedIndexChanged += new System.EventHandler(this.lvAntigenTyping_SelectedIndexChanged);
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Specificity";
			this.columnHeader2.Width = 100;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Date Tested";
			this.columnHeader1.Width = 120;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Interpretation";
			this.columnHeader3.Width = 100;
			// 
			// grpInvalidateTyping
			// 
			this.grpInvalidateTyping.AccessibleDescription = "invalidate";
			this.grpInvalidateTyping.AccessibleName = "invalidate";
			this.grpInvalidateTyping.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpInvalidateTyping.Controls.Add(this.txtAntigenInactivateComment);
			this.grpInvalidateTyping.Controls.Add(this.lblAntigenTypingCommentDetails);
			this.grpInvalidateTyping.Controls.Add(this.cmbAntigenInactivateComment);
			this.grpInvalidateTyping.Controls.Add(this.label1);
			this.grpInvalidateTyping.Controls.Add(this.btnInvalidateAntigenTyping);
			this.grpInvalidateTyping.Location = new System.Drawing.Point(4, 192);
			this.grpInvalidateTyping.Name = "grpInvalidateTyping";
			this.grpInvalidateTyping.Size = new System.Drawing.Size(322, 104);
			this.grpInvalidateTyping.TabIndex = 2;
			this.grpInvalidateTyping.TabStop = false;
			this.grpInvalidateTyping.Text = "Invalidate";
			// 
			// txtAntigenInactivateComment
			// 
			this.txtAntigenInactivateComment.AccessibleDescription = "details";
			this.txtAntigenInactivateComment.AccessibleName = "details";
			this.txtAntigenInactivateComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntigenInactivateComment.Location = new System.Drawing.Point(76, 40);
			this.txtAntigenInactivateComment.MaxLength = 255;
			this.txtAntigenInactivateComment.Multiline = true;
			this.txtAntigenInactivateComment.Name = "txtAntigenInactivateComment";
			this.txtAntigenInactivateComment.Size = new System.Drawing.Size(236, 32);
			this.txtAntigenInactivateComment.TabIndex = 3;
			this.txtAntigenInactivateComment.Text = "";
			this.txtAntigenInactivateComment.TextChanged += new System.EventHandler(this.txtAntigenInactivateComment_TextChanged);
			// 
			// lblAntigenTypingCommentDetails
			// 
			this.lblAntigenTypingCommentDetails.Location = new System.Drawing.Point(8, 40);
			this.lblAntigenTypingCommentDetails.Name = "lblAntigenTypingCommentDetails";
			this.lblAntigenTypingCommentDetails.Size = new System.Drawing.Size(68, 20);
			this.lblAntigenTypingCommentDetails.TabIndex = 2;
			this.lblAntigenTypingCommentDetails.Text = "Details";
			this.lblAntigenTypingCommentDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbAntigenInactivateComment
			// 
			this.cmbAntigenInactivateComment.AccessibleDescription = "comment";
			this.cmbAntigenInactivateComment.AccessibleName = "comment";
			this.cmbAntigenInactivateComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbAntigenInactivateComment.DropDownWidth = 139;
			this.cmbAntigenInactivateComment.Interval = 500;
			this.cmbAntigenInactivateComment.Location = new System.Drawing.Point(76, 16);
			this.cmbAntigenInactivateComment.Name = "cmbAntigenInactivateComment";
			this.cmbAntigenInactivateComment.Size = new System.Drawing.Size(238, 20);
			this.cmbAntigenInactivateComment.TabIndex = 1;
			this.cmbAntigenInactivateComment.SelectedIndexChanged += new System.EventHandler(this.cmbAntigenInactivateComment_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(68, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "Comment*";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnInvalidateAntigenTyping
			// 
			this.btnInvalidateAntigenTyping.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnInvalidateAntigenTyping.EnabledButton = false;
			this.btnInvalidateAntigenTyping.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnInvalidateAntigenTyping.Image = ((System.Drawing.Image)(resources.GetObject("btnInvalidateAntigenTyping.Image")));
			this.btnInvalidateAntigenTyping.Location = new System.Drawing.Point(148, 76);
			this.btnInvalidateAntigenTyping.Name = "btnInvalidateAntigenTyping";
			this.btnInvalidateAntigenTyping.Size = new System.Drawing.Size(164, 23);
			this.btnInvalidateAntigenTyping.TabIndex = 4;
			this.btnInvalidateAntigenTyping.Click += new System.EventHandler(this.btnInvalidateAntigenTyping_Click);
			this.btnInvalidateAntigenTyping.MouseHover += new System.EventHandler(this.btnInvalidateAntigenTyping_MouseHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(580, 372);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 3;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnInactivateUnit
			// 
			this.btnInactivateUnit.AccessibleDescription = "Inactivate Unit";
			this.btnInactivateUnit.AccessibleName = "Inactivate Unit";
			this.btnInactivateUnit.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.hlphelpChm.SetHelpKeyword(this.btnInactivateUnit, "Edit_Unit_Information.htm");
			this.hlphelpChm.SetHelpNavigator(this.btnInactivateUnit, System.Windows.Forms.HelpNavigator.Topic);
			this.btnInactivateUnit.Image = ((System.Drawing.Image)(resources.GetObject("btnInactivateUnit.Image")));
			this.btnInactivateUnit.Location = new System.Drawing.Point(148, 344);
			this.btnInactivateUnit.Name = "btnInactivateUnit";
			this.hlphelpChm.SetShowHelp(this.btnInactivateUnit, true);
			this.btnInactivateUnit.Size = new System.Drawing.Size(164, 23);
			this.btnInactivateUnit.TabIndex = 1;
			this.btnInactivateUnit.Click += new System.EventHandler(this.btnInactivateUnit_Click);
			// 
			// bloodUnitSelectorVertical1
			// 
			this.bloodUnitSelectorVertical1.AccessibleDescription = "Unit Search";
			this.bloodUnitSelectorVertical1.AccessibleName = "Unit Search";
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
			this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(60, 32);
			this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
			this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 308);
			this.bloodUnitSelectorVertical1.TabIndex = 0;
			this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_SearchClick);
			this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelectorVertical1_UnitUpdated);
			this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_ClearBtnClick);
			// 
			// FrmEditUnitProcessing
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(660, 408);
			this.Controls.Add(this.btnInactivateUnit);
			this.Controls.Add(this.bloodUnitSelectorVertical1);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.tabEditUnit);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "Edit_Unit_Information.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(668, 435);
			this.Name = "FrmEditUnitProcessing";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Edit Unit Information";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmEditUnitProcessing_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.tabEditUnit, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.bloodUnitSelectorVertical1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnInactivateUnit, 0);
			this.grpImage.ResumeLayout(false);
			this.tabEditUnit.ResumeLayout(false);
			this.pageUnitInformation.ResumeLayout(false);
			this.grpVolume.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updDiscardedPlasmaVolume)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updVolume)).EndInit();
			this.grpRestrictedFor.ResumeLayout(false);
			this.grpRestrictions.ResumeLayout(false);
			this.grpBiohazardous.ResumeLayout(false);
			this.pageABORhConfirmation.ResumeLayout(false);
			this.grpInvalidateConfirmation.ResumeLayout(false);
			this.grpABORhConfirmation.ResumeLayout(false);
			this.pageAntigenTyping.ResumeLayout(false);
			this.grpAntigenTyping.ResumeLayout(false);
			this.grpInvalidateTyping.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Events

		#region Blood Unit Selector

		/// <summary>
		/// When the user enters a valid product code and unit id
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelectorVertical1_UnitUpdated(object sender, System.EventArgs e)
		{
			try
			{
				this._isLoading = true;
				this.GetBloodUnit();
				if(this._bloodUnit != null)
				{
					this.SetControlData(true);
					this.SetControlState(true);
					this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
					//
					// This flag gets set if the user hits return after 
					// entering a valid unit and product, even though 
					// nothing has been changed yet; so, we set it back
					this.IsDirty = false;
				}
				//
				this._isLoading = false;
			}
			catch( Exception err )
			{
				this.UnlockAllRecords();
				this._bloodUnit = null;
				this._aboRhConfirmationTests = null;
				this._antigenTypingTests = null;
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, err.Message); // **** 508 Compliance ***
				this.btnOK.EnabledButton = false;
				this.SetControlData(false);
				this.SetControlState(false);
			}
		}

		/// <summary>
		/// When the user clicks the search button on the blood unit selector
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelectorVertical1_SearchClick(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				try
				{
					this.Working();
					//
					DataTable eligDt;
					// Get a list of valid units for this division
					if ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId < (int)Common.UserRoleType.TraditionalSupervisor)
					{
						eligDt = BOL.BloodUnit.GetBloodUnitsForEdit(false);
					}
					else
					{
						eligDt = BOL.BloodUnit.GetBloodUnitsForEdit(true);
					}
					
					// Create a new dialog window and set the required properties...
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligDt, this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Select Unit for Editing";
					unitSelector.LogoBarText = "Select Unit for Editing";

					unitSelector.ShowDialogFromLockedParent(this,false);
					
					// If everything went ok, we'll just grab the top row and populate the BloodUnitSelector
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						this.Refresh();
						System.Data.DataRow dr = unitSelector.SelectedUnits.Rows[0];

						this.bloodUnitSelectorVertical1.DisplayBloodUnit(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
					}
					eligDt.Dispose();
					eligDt = null;
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
					//A record has been loaded with new values, the initial state of 
					//the page is not dirty.
					this.IsDirty = false;
				}
			}
		}

		/// <summary>
		/// This clears the UnitId and productCode fields, as well as the form variables
		/// and also removes the lock
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void bloodUnitSelectorVertical1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this._isClearing = true;
			//
			this.ClearUnitInfo();
            //CR 3432
		    this.IsDirty = false;
			//
			this._isClearing = false;
		}

		#endregion

		#region Control Edits
		
		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/21/2004</CreationDate>
		///
		/// <summary>
		/// Let's us know if the user changed something 
		/// in special testing
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void specialTesting1_IsDirtyChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading  && !this._isClearing) 
			{
				this.IsDirty = true;
				EnableOkButton();
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>04/21/2006</CreationDate>
		///
		/// <summary> 
		/// If the user selects an antigen, we have to check the login, update, 
		/// or test antigens to make sure the selected antigen is not in conflict.  
		/// If there is a conflict, the warning message in BR_41.12 will appear. 
		/// The user may then correct the anomaly or proceed with save.  If he/she 
		/// saves it, the unit will be quarantined.
		/// Implements BR_41.12
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void specialTesting1_AntigenUpdated(object sender, EventArgs e)
		{
			if (!this._isLoading)
			{
				int antigenChangedTypeId = this.specialTesting1.AntigenChangedTypeId;
				//
				// User has chosen to check antigen check box
				if(this.specialTesting1.AntigenChangedChecked)
				{
					// Part I. Check login or updated antigens
					for (int idx = 0; idx < this.specialTesting1.AntigensList.Count; idx++)
					{
						BOL.BloodUnitAntigen antigen = (BOL.BloodUnitAntigen)this.specialTesting1.AntigensList[idx];
						//
						if (antigenChangedTypeId == antigen.AntigenTypeId)
						{
							if(this.specialTesting1.AntigenChangedType.Equals(_antigenTypeNeg) && antigen.Positive ||
								this.specialTesting1.AntigenChangedType.Equals(_antigenTypePos) && !antigen.Positive )
							{
								// Keep track of the checked antigens in conflict with the login/update ones
								// so we may quarantine the unit at save time, if necessary
								if(!this._invalidAntigens.Contains(antigenChangedTypeId))
								{
									this._invalidAntigens.Add(antigenChangedTypeId);
									//
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC070.InconsistentAntigenType());
								}
							}
							//
							break;
						}
					}
					//
					// Part II. Check antigen typing tests
					if(this._antigenTypingTests != null && this._antigenTypingTests.Count > 0)
					{
						for (int idx = 0; idx < this._antigenTypingTests.Count; idx++)
						{
							BOL.BloodUnitTest buTest = (BOL.BloodUnitTest)this._antigenTypingTests[idx];
							//
							int antigenTestedBloodTestTypeId = buTest.BloodTestTypeObj.BloodTestTypeId;
							//
							int antigenTestedTypeId = Convert.ToInt32(_antigenTestMap[antigenTestedBloodTestTypeId]);
							//
							if (antigenChangedTypeId == antigenTestedTypeId)
							{
								Common.TestResult tr = Common.Utility.GetTestResultEnumFromString(buTest.TestResultId.Trim());
								//
								if(this.specialTesting1.AntigenChangedType.Equals(_antigenTypeNeg) && tr == Common.TestResult.P ||
									this.specialTesting1.AntigenChangedType.Equals(_antigenTypePos) && tr == Common.TestResult.N )
								{
									// Keep track of the checked antigens in conflict with the tested ones
									// so we may quarantine the unit at save time, if necessary
									if(!this._invalidAntigens.Contains(antigenChangedTypeId))
									{
										this._invalidAntigens.Add(antigenChangedTypeId);
										//
										GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC070.InconsistentAntigenType());
									}
								}
								//
								break;
							}
						}
					}
				} // if(this.specialTesting1.AntigenChanged)
				else
				{
					// If the user un-checks an antigen, check for and
					// remove it from the list of invalid antigens (if
					// it's on the list)
					if(this._invalidAntigens.Contains(antigenChangedTypeId))
					{
						this._invalidAntigens.Remove(antigenChangedTypeId);
					}
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/14/2004</CreationDate>
		///
		/// <summary>
		/// Numeric up/down leave event handler. 
		/// Does not allow non integer inputs
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void updVolume_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading  && !this._isClearing) 
			{
				try
				{
					int val = (int)this.updVolume.Value;
					//
					// BR_70.26
					if(val == 0 && !this._isClearing)
					{
						val = 1;
					}
					this.updVolume.Value = val;
					this._originalVolumeChanged = true;
					EnableOkButton();
					this.errError.SetVbecsError(updVolume, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					this.errError.SetVbecsError(updVolume, err.Message); // **** 508 Compliance ***
					this.btnOK.EnabledButton = false;
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/18/2002</CreationDate>
		///
		/// <summary>
		/// Numeric up/down text changed event handler. 
		/// Does not allow non integer inputs
		/// Implements BR_70.26
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void updVolume_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading  && !this._isClearing) 
			{
				try
				{
					int val = (int)this.updVolume.Value;
					//
					// BR_70.26
					if(val == 0 && !this._isClearing)
					{
						val = 1;
					}
					this.updVolume.Value = val;
					this._originalVolumeChanged = true;
					EnableOkButton();
					this.errError.SetVbecsError(updVolume, string.Empty); // **** 508 Compliance ***

					this.IsDirty = true;
				}
				catch(Exception)
				{
					this.btnOK.EnabledButton = false;
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/14/2004</CreationDate>
		///
		/// <summary>
		/// Numeric up/down text changed event handler. 
		/// Does not allow non integer inputs
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void updDiscardedPlasmaVolume_ValueChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading) 
			{
				try
				{
					this.updDiscardedPlasmaVolume.Value = (int)this.updDiscardedPlasmaVolume.Value;
					this._discardedPlasmaVolumeChanged = true;
					this.btnOK.EnabledButton = !( ( (int)this.updDiscardedPlasmaVolume.Value == 0 ) && this.updDiscardedPlasmaVolume.Enabled );
					this.errError.SetVbecsError(updDiscardedPlasmaVolume, string.Empty); // **** 508 Compliance ***

					this.IsDirty = true;
				}
				catch(FormatException)
				{
					this.btnOK.EnabledButton = false;
				}
			}
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>07/18/2002</CreationDate>
		///
		/// <summary>
		/// Numeric up/down leave event handler. 
		/// Does not allow non integer inputs
		/// </summary>
		/// <param name="sender">object</param>
		/// <param name="e">System.EventArgs</param>
		private void updDiscardedPlasmaVolume_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading) 
			{
				try
				{
					this.updDiscardedPlasmaVolume.Value = (int)this.updDiscardedPlasmaVolume.Value;
					this._discardedPlasmaVolumeChanged = true;
					this.btnOK.EnabledButton = !( ( (int)this.updDiscardedPlasmaVolume.Value == 0 ) && this.updDiscardedPlasmaVolume.Enabled );
					this.errError.SetVbecsError(updDiscardedPlasmaVolume, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					this.errError.SetVbecsError(updDiscardedPlasmaVolume, err.Message); // **** 508 Compliance ***
					this.btnOK.EnabledButton = false;
				}
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/21/2004</CreationDate>
		///
		/// <summary>
		/// When the user clicks the 'Biohazardous' check box
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbBiohazardous_CheckedChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading) 
			{
				this.IsDirty = true;
				this._biohazardousWarningIndicatorChanged = true;
				EnableOkButton();
			}
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>09/21/2004</CreationDate>
		///
		/// <summary>
		/// When the user clicks the 'Testing Status' combo box
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbTestingStatus_TextChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading) 
			{
				this.IsDirty = true;
				this._testingStatusIdChanged = true;
				EnableOkButton();
			}
		}

		/// <summary>
		/// When the user selects a different Abo/Rh Invalidation Comment
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbAboRhInactivateComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!(this._isLoading))
			{
				if (this.cmbAboRhInactivateComment.SelectedIndex > 0)
				{
					if (this.cmbAboRhInactivateComment.Text.Trim().ToUpper() == "OTHER")
					{
						this.lblAboRhConfirmationCommentDetails.Text = "Details*";
						this.txtAboRhInactivateComment.MaxLength = 255;
						this.txtAboRhInactivateComment.Focus();
						if (this.txtAboRhInactivateComment.Text.Trim().Length == 0)
							this.btnInvalidateABORhConfirmation.EnabledButton = false;
					}
					else
					{
						this.lblAboRhConfirmationCommentDetails.Text = "Details";
						this.txtAboRhInactivateComment.MaxLength = (255 - cmbAboRhInactivateComment.Text.Length);
						if (this.lvABORhConfirmation.SelectedIndices.Count > 0)
							this.btnInvalidateABORhConfirmation.EnabledButton = true;
					}
				}
				else
				{
					this.lblAboRhConfirmationCommentDetails.Text = "Details";
					this.btnInvalidateABORhConfirmation.EnabledButton = false;
				}
			}
		}

		/// <summary>
		/// When the user selects a dfferent Antigen Typing Invalidation Comment
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbAntigenInactivateComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!(this._isLoading))
			{
				if (this.cmbAntigenInactivateComment.SelectedIndex > 0)
				{
					if (this.cmbAntigenInactivateComment.Text.Trim().ToUpper() == "OTHER")
					{
						this.lblAntigenTypingCommentDetails.Text = "Details*";
						this.txtAntigenInactivateComment.MaxLength = 255;
						this.txtAntigenInactivateComment.Focus();
						if (this.txtAntigenInactivateComment.Text.Trim().Length == 0)
							this.btnInvalidateAntigenTyping.EnabledButton = false;
					}
					else
					{
						this.lblAntigenTypingCommentDetails.Text = "Details";
						this.txtAntigenInactivateComment.MaxLength = (255 - cmbAntigenInactivateComment.Text.Length);
						if (this.lvAntigenTyping.SelectedIndices.Count > 0)
							this.btnInvalidateAntigenTyping.EnabledButton = true;
					}
				}
				else
				{
					this.lblAntigenTypingCommentDetails.Text = "Details";
					this.btnInvalidateAntigenTyping.EnabledButton = false;
				}
			}
		}

		/// <summary>
		/// When a user enters free-form text in the Abo/Rh comment textbox
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtAboRhInactivateComment_TextChanged(object sender, System.EventArgs e)
		{
			if (this.lvABORhConfirmation.SelectedIndices.Count > 0)
			{
				if ((this.txtAboRhInactivateComment.Text.Trim().Length == 0) && 
					(this.cmbAboRhInactivateComment.Text.Trim().ToUpper() == "OTHER"))
					this.btnInvalidateABORhConfirmation.EnabledButton = false;
				else
					this.btnInvalidateABORhConfirmation.EnabledButton = true;
			}
			else
				this.btnInvalidateABORhConfirmation.EnabledButton = false;
		}

		/// <summary>
		/// When a user enters free-form text in the Antigen Typing Comment textbox
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtAntigenInactivateComment_TextChanged(object sender, System.EventArgs e)
		{
			if (this.lvAntigenTyping.SelectedIndices.Count > 0)
			{
				if ((this.txtAntigenInactivateComment.Text.Trim().Length == 0) && 
					(this.cmbAntigenInactivateComment.Text.Trim().ToUpper() == "OTHER"))
					this.btnInvalidateAntigenTyping.EnabledButton = false;
				else
					this.btnInvalidateAntigenTyping.EnabledButton = true;
			}
			else
				this.btnInvalidateAntigenTyping.EnabledButton = false;
		}

		/// <summary>
		/// When the user selects a different line item on the abo/rh confirmation tab
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvABORhConfirmation_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				ClearAboRhConfirmationTab();
				if (this.lvABORhConfirmation.SelectedIndices.Count > 0)
				{
					// Enable comments selection
					this.cmbAboRhInactivateComment.Enabled = true;
					this.txtAboRhInactivateComment.ReadOnly = false;
					
					String currentGuid = this.lvABORhConfirmation.SelectedItems[0].SubItems[3].Text;
					foreach(BOL.BloodUnitTest buTest in _aboRhConfirmationTests)
					{
						if (buTest.ConfirmationWorklistUnitGuid.ToString() == currentGuid)
						{
							switch (buTest.BloodTestTypeObj.BloodTestTypeId)
							{
								case 15:
									this.txtAntiA.Text = buTest.TestResultId;
									break;
								case 16:
									this.txtAntiB.Text = buTest.TestResultId;
									break;
								case 17:
									this.txtAntiAB.Text = buTest.TestResultId;
									break;
								case 18:
									this.txtABOInterpretation.Text = buTest.TestResultId;
									this.txtABOComment.Text = buTest.TestComments;
									break;
								case 19:
									this.txtAntiD.Text = buTest.TestResultId;
									break;
								case 20:
									this.txtDControl.Text = buTest.TestResultId;
									break;
								case 21:
									this.txtRhInterpretation.Text = buTest.TestResultId;
									this.txtRhComment.Text = buTest.TestComments;
									break;
							}
						}
					}
				}
				else
				{
					this.cmbAboRhInactivateComment.Enabled = false;
					this.txtAboRhInactivateComment.ReadOnly = true;
				}
			}
		}

		/// <summary>
		/// When the user selects a different line item on the antigen typing tab
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvAntigenTyping_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ArrayList phases = new ArrayList();
			if (!this._isLoading)
			{
				ClearAntigenTypingTab();
				if (this.lvAntigenTyping.SelectedIndices.Count > 0)
				{
					// Enable comments selection
					this.cmbAntigenInactivateComment.Enabled = true;
					this.txtAntigenInactivateComment.ReadOnly = false; //508 compliance
					
					//
					String currentGuid = this.lvAntigenTyping.SelectedItems[0].SubItems[3].Text;
					foreach(BOL.BloodUnitTest buTest in _antigenTypingTests)
					{
						if (buTest.AntiseraWorklistTypingGuid.ToString() == currentGuid)
						{
							if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("Interp") > -1)
							{
								this.txtAntigenTypingInterpretation.Text = buTest.TestResultId;
								this.txtAntiserum.Text = buTest.Reagent.ReagentName;
								this.txtLotNumber.Text = buTest.Reagent.LotNumber;
								this.txtAntigenTypingComment.Text = buTest.TestComments;
							}
							if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("IS") > -1)
							{
								phases.Add("IS");
								this.txtIS.Text = buTest.TestResultId;
							}
							if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("RT") > -1)
							{
								phases.Add("RT");
								this.txtRT.Text = buTest.TestResultId;
							}
							if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("37C") > -1)
							{
								phases.Add("37");
								this.txt37C.Text = buTest.TestResultId;
							}
							if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("AHG") > -1)
							{
								phases.Add("AHG");
								this.txtAHG.Text = buTest.TestResultId;
							}
							if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("CC") > -1)
							{
								phases.Add("CC");
								this.txtCC.Text = buTest.TestResultId;
							}
						}
					}

					if(phases.IndexOf("37") > -1 || phases.IndexOf("RT") > -1)
					{
						_workloadAntigenTestingProcessId = Common.WorkloadProcessID.UnitAntigenPhenotypingMultipleTestPhases;
					}
					else if((phases.IndexOf("IS") > -1 && phases.IndexOf("37") == -1 && phases.IndexOf("RT") == -1) ||
						(phases.IndexOf("AHG") > -1))
					{	
						_workloadAntigenTestingProcessId = Common.WorkloadProcessID.UnitAntigenPhenotypingSingleTestPhase;
					}
				}
				else
				{
					this.cmbAntigenInactivateComment.Enabled = false;
					//508 compliance
					this.txtAntigenInactivateComment.ReadOnly = true;
				}
			}
		}

		/// <summary>
		/// When the user selects a different tab page
		/// 
		/// 508 Compliance Update: user activity in either of the test invalidation tabs should
		/// not result in a dirty form: these tabs save independently of the 
		/// rest of the form.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tabEditUnit_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			switch(tabEditUnit.SelectedTab.Name)
			{
				case "pageABORhConfirmation":
				{
					this.AcceptButton = this.btnInvalidateABORhConfirmation; // **** 508 Compliance ***
					this._isDirtyTemp = this.IsDirty; // **** 508 Compliance ***
					ClearAntigenTypingTab();
					this.lvAntigenTyping.SelectedItems.Clear();
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC070.FrmEditUnitProcessing_Invalidate());
					this.IsDirty = this._isDirtyTemp; // **** 508 Compliance ***
					break;
				}
				case "pageAntigenTyping":
				{
					this.AcceptButton = this.btnInvalidateAntigenTyping; // **** 508 Compliance ***
					this._isDirtyTemp = this.IsDirty; // **** 508 Compliance ***
					ClearAboRhConfirmationTab();
					this.lvABORhConfirmation.SelectedItems.Clear();
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC070.FrmEditUnitProcessing_Invalidate());
					this.IsDirty = this._isDirtyTemp; // **** 508 Compliance ***
					break;
				}
				default:
				{
					this.AcceptButton = this.btnOK; // **** 508 Compliance ***
					ClearAntigenTypingTab();
					this.lvAntigenTyping.SelectedItems.Clear();
					ClearAboRhConfirmationTab();
					this.lvABORhConfirmation.SelectedItems.Clear();
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC070.FrmEditUnitProcessing_UnitInfo());
					this.IsDirty = this._isDirtyTemp; // **** 508 Compliance ***
					break;
				}
			}
		}
		
		/// <summary>
		/// When the user changes the Disease Marker Testing
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbTestingStatus_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading && !this._isClearing)
			{
				if(this._bloodUnit != null)
				{
					if (this.cmbTestingStatus.SelectedIndex > -1)
					{
						// BR_70.22, 12.13
						if(cmbTestingStatus.SelectedIndex == 0)
						{
							//CR 2311
							if(Common.Utility.IsAutologous(this._bloodUnit.DonationType.DonationTypeId) || 
								this._bloodUnit.DonationType.DonationTypeId == (int) Common.DonationTypeId.ForAutologousUseOnlyBiohazardous ||
								this._bloodUnit.DonationType.DonationTypeId == (int) Common.DonationTypeId.ForDirectedDonorUseOnlyBiohazardous ||
								this._bloodUnit.BloodUnitStatus.QuarantineIndicator)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic("You must select a valid testing status."));
								this.btnOK.SetToolTip("You must select a valid testing status.");
								BrokenFormRulesCount += 1;
							}
							else
							{	
								this.HandlecmbTestingStatusChange();
								this._testingStatusIdChanged = true;
								BrokenFormRulesCount -= 1;
							}
						}
						else
						{	
							this.HandlecmbTestingStatusChange();
							this._testingStatusIdChanged = true;
							BrokenFormRulesCount -= 1;
						}
					}
				}
				this.IsDirty = true;
				EnableOkButton();
			}
		}

		#endregion

		#region Button Clicks

		/// <summary>
		/// When the user clicks on the "..." button for selecting a patient
		/// to restrict this blood unit for
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSelectPatient_Click(object sender, System.EventArgs e)
		{
			try
			{
				FrmPatientSelect frm = new FrmPatientSelect(true );

                frm.ShowDialogFromLockedParent(this, false);

				if( frm.DialogResult != DialogResult.OK )
					return;

				if( frm.SelectedPatient != null )
				{
					this._bloodUnit.DirectedPatient = (BOL.Patient)frm.SelectedPatient;
					this._bloodUnit.BloodUnitMedia.DirectedPatientGuid = (System.Guid) frm.SelectedPatient.PatientGuid;
					this.txtRestrictedPatient.Text = this._bloodUnit.DirectedPatient.DisplayName;
					this.errError.SetVbecsError(this.btnSelectPatient, string.Empty); // **** 508 Compliance ***
					EnableOkButton();					
					this.IsDirty = true; // form is dirty 
					this._restrictedPatientChanged = true;
				}
				else
				{
					if( this._bloodUnit.DirectedPatient == null )
						return;

					this.errError.SetVbecsError(this.btnSelectPatient, Common.StrRes.Tooltips.UC001.BR137_RestrictPatient().ResString); // **** 508 Compliance ***
					this.btnOK.EnabledButton = false;
				}
			}
			catch (Exception ex)
			{
				this.errError.SetVbecsError(this.btnSelectPatient, ex.Message); // **** 508 Compliance ***
				this.btnOK.EnabledButton = false;
				return;
			}
		}

		/// <summary>
		/// When the user clicks the 'Cancel' button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// When the user clicks the 'OK' button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult saveResult = GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.Common.OKToSave("blood unit") );
	
			if( saveResult != DialogResult.Yes )
				return;

			using ( new WaitCursor() )
			{
				try
				{
					this._bloodUnit.LastUpdateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					this._bloodUnit.LastUpdateUser = ThisUser.UserNTLoginID;

					// Determine if anything changed, Blood Unit/Media/Status wise
					byte bloodUnitFieldChanged = 0;
					if (this._originalVolumeChanged)
					{
						this._bloodUnit.OriginalVolume = this.updVolume.Value;
						bloodUnitFieldChanged += 1;
					}
					if (this._discardedPlasmaVolumeChanged)
					{
						this._bloodUnit.DiscardedPlasmaVolume = this.updDiscardedPlasmaVolume.Value;
						bloodUnitFieldChanged += 1;
					}
					if (this._testingStatusIdChanged)
					{
						this._bloodUnit.BloodUnitMedia.TestingStatusId = GetTestingStatusID(this.cmbTestingStatus.SelectedItem.ToString());
						bloodUnitFieldChanged += 1;
					}
					if (this._biohazardousWarningIndicatorChanged)
					{
						this._bloodUnit.BloodUnitStatus.BiohazardousWarningIndicator = this.cbBiohazardous.Checked;
						bloodUnitFieldChanged += 1;
					}
					if (this._restrictedPatientChanged)
					{
						bloodUnitFieldChanged += 1;
					}
					bool bloodUnitChanged = (bloodUnitFieldChanged > 0);
					// *************************************************************************************************
					// Determine if anything changed, Special Testing wise
					ArrayList buTests = null;
					
					// If the user changed the CMV Test, save it
					if (this.specialTesting1.CmvTest.IsDirty && !this.specialTesting1.CmvTest.TestResultId.Trim().Equals(this._cmvTestOrigTestId.Trim()))
					{
						if( buTests == null )
							buTests = new ArrayList();

						buTests.Add(this.specialTesting1.CmvTest);
					}
					
					// If the user changed the Sickle Cell Test, save it
					if (this.specialTesting1.SickleCellTest.IsDirty && !this.specialTesting1.SickleCellTest.TestResultId.Trim().Equals(this._scTestOrigTestId.Trim()))
					{
						if( buTests == null )
							buTests = new ArrayList();

						buTests.Add(this.specialTesting1.SickleCellTest);
					}
					bool bloodUnitTestsChanged = buTests == null ? false : true;
					//
					// *************************************************************************************************
					// Determine if anything changed, Antigens wise
					bool antigensChanged = this.specialTesting1.AntigensChanged;
					//
					// *************************************************************************************************
					// If there are any antigens in conflict with tested values, we need to quarantine the unit
					bool quarantineUnit = this._invalidAntigens.Count > 0;
					//
					// *************************************************************************************************
					if(bloodUnitChanged || bloodUnitTestsChanged || antigensChanged)
					{
						bool removeAllAntigens = (antigensChanged && this.specialTesting1.AntigensList.Count == 0);
						if (this._bloodUnit.Save(
							bloodUnitChanged, 
							removeAllAntigens, 
							quarantineUnit,
							this.specialTesting1.AntigensList, 
							buTests,  
							Common.UpdateFunction.UC070FrmEditUnitProcessing))
						{
							//CR 1441
							System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) this._workloadAntigenTestingProcessId);
							if(dt!= null && _workloadAntigenTestingProcessId != Common.WorkloadProcessID.Unknown)
							{
								if(dt.Rows.Count == 0)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
								}
							}
							this.bloodUnitSelectorVertical1_ClearBtnClick(sender, e);
							this.bloodUnitSelectorVertical1.DisplayBloodUnit(string.Empty,string.Empty);
							this.UnlockAllRecords();
							// Set focus so they can go another round
							this.bloodUnitSelectorVertical1.txtUnitID.Focus();
							// update successful, page no longer dirty
							this.IsDirty = false;
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Blood unit"));
						}
					}
					else
					{
						DialogResult dr = GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic("No information was changed."));
					}
				}
				catch(RowVersionException)
				{
					this.btnOK.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
		}

		/// <summary>
		/// When user clicks the "Inactivate Test" button on the Abo/Rh Confirmation tab
		/// Implements BR_70.25
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnInvalidateABORhConfirmation_Click(object sender, System.EventArgs e)
		{
			DialogResult inactivateResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC070.InactivateAboRhConfirmation());
			if( inactivateResult != DialogResult.Yes )
			{
				return;
			}
			//
			using ( new WaitCursor() )
			{
				try			
				{
					string inactivateComment = String.Empty;
					if( this.cmbAboRhInactivateComment.SelectedIndex > 0 )
					{
						if( this.cmbAboRhInactivateComment.Text.Trim().ToUpper() == "OTHER" )
							inactivateComment = this.txtAboRhInactivateComment.Text;
						else
							inactivateComment = this.cmbAboRhInactivateComment.Text + this.txtAboRhInactivateComment.Text;
					}
					else
					{
						inactivateComment = this.txtAboRhInactivateComment.Text;
					}
					//
					if( inactivateComment.Length == 0 )
					{
						throw( new BusinessObjectException( Common.StrRes.SysErrMsg.UC070.InactivationCommentRequired().ResString ) );
					}
				
					//start CR 1441, 2173
					bool performAntiD = false;

					for ( int idx = 0; idx < this._aboRhConfirmationTests.Count; idx++ )
					{
						BOL.BloodUnitTest bloodUnitTest = (BOL.BloodUnitTest)this._aboRhConfirmationTests[idx];

						if(bloodUnitTest.BloodTestTypeObj.BloodTestTypeId == (int) Common.TestType.AntiD)
						{
							performAntiD = true;
						}
					}
				
					System.Data.DataTable dt = null;
	
					if(performAntiD == false)
					{
						dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.ABOForwardTypingUnit);
					}
					else
					{
						dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) Common.WorkloadProcessID.ABORhForwardTypingUnit);
					}

					
					
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
					//end CR 1441, 2173
					// BR_70.25 : if all tests have been selected to be invalidated, we need to return status to limited
					bool allTestsInactivated = ( this.lvABORhConfirmation.Items.Count == this.lvABORhConfirmation.SelectedItems.Count );
					//
					BOL.BloodUnitTest.InactivateAboRHConfirmationTests( this._bloodUnit, (new System.Guid(this.lvABORhConfirmation.SelectedItems[0].SubItems[3].Text)), inactivateComment, Common.UpdateFunction.UC070FrmEditUnitProcessing, this._aboRhConfirmationTests, allTestsInactivated );
					this.lvABORhConfirmation.Items.RemoveAt(this.lvABORhConfirmation.SelectedItems[0].Index);
					ClearAboRhConfirmationTab();
					this.lvABORhConfirmation.SelectedItems.Clear();
					//
					// If nothing else was changed on the form, re-set the IsDirty flag
					if (!this._isDirtyTemp)
					{
						this.IsDirty = false;
					}
				}
				catch (med.vbecs.Common.RowVersionException)
				{
					this.btnInvalidateABORhConfirmation.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
		}

		/// <summary>
		/// Displays a message as user hovers over the button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnInvalidateABORhConfirmation_MouseHover(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			if ( this.lvABORhConfirmation.Items != null && this.lvABORhConfirmation.Items.Count > 0 )
			{
				if (this.lvABORhConfirmation.SelectedIndices.Count > 0)
				{
					string inactivateComment = String.Empty;
					if (this.cmbAboRhInactivateComment.SelectedIndex > 0)
					{
						if (this.cmbAboRhInactivateComment.Text.Trim().ToUpper() == "OTHER")
						{
							inactivateComment = this.txtAboRhInactivateComment.Text;
						}
						else
						{
							inactivateComment = string.Concat(this.cmbAboRhInactivateComment.Text, this.txtAboRhInactivateComment.Text);
						}
					}
					else
					{
						inactivateComment = this.txtAboRhInactivateComment.Text;
					}
					if (inactivateComment.Length == 0)
					{
						this.btnInvalidateABORhConfirmation.SetToolTip(Common.StrRes.Tooltips.Common.EnterAComment().ResString);
					}
					else
					{
						this.btnInvalidateABORhConfirmation.SetToolTip(String.Empty);
					}
				}
				else
				{
					this.btnInvalidateABORhConfirmation.SetToolTip(Common.StrRes.Tooltips.UC070.SelectTest().ResString);
				}
			}
			else
			{
				// **** 508 Compliance ***
				this.btnInvalidateABORhConfirmation.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
		}

		/// <summary>
		/// When user clicks the "Inactivate Test" button on the Antigen Typing tab
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnInvalidateAntigenTyping_Click(object sender, System.EventArgs e)
		{
			System.Guid lockGuid = (System.Guid)this.lvAntigenTyping.SelectedItems[0].Tag;

			DialogResult inactivateResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC070.InactivateAntigenTyping());
			
			if (inactivateResult == DialogResult.Yes)
			{
				if (!this.SetLocks(lockGuid))
					return;

				using ( new WaitCursor() )
				{
					try
					{
						string inactivateComment = String.Empty;
						if (this.cmbAntigenInactivateComment.SelectedIndex > 0)
						{
							if (this.cmbAntigenInactivateComment.Text.Trim().ToUpper() == "OTHER")
							{
								inactivateComment = this.txtAntigenInactivateComment.Text;
							}
							else
							{
								inactivateComment = this.cmbAntigenInactivateComment.Text + this.txtAntigenInactivateComment.Text;
							}
						}
						else
						{
							inactivateComment = this.txtAntigenInactivateComment.Text;
						}
						if (inactivateComment.Length == 0)
						{
							this.ReleaseLocks(lockGuid);
							throw(new BusinessObjectException(Common.StrRes.SysErrMsg.UC070.InactivationCommentRequired().ResString));
						}
						//
						BOL.BloodUnitTest.InactivateAntigenTypingTests
							(
							this._bloodUnit.BloodUnitGuid,
							(new System.Guid(this.lvAntigenTyping.SelectedItems[0].SubItems[3].Text)), 
							inactivateComment, 
							Common.UpdateFunction.UC070FrmEditUnitProcessing,
							this._workloadAntigenTestingProcessId,
							this._antigenTypingTests
							);

						//CR 1441, 2173
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) this._workloadAntigenTestingProcessId);
						if(dt!= null && _workloadAntigenTestingProcessId != Common.WorkloadProcessID.Unknown)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}
						this.lvAntigenTyping.Items.RemoveAt(this.lvAntigenTyping.SelectedItems[0].Index);
						ClearAntigenTypingTab();
						this.lvAntigenTyping.SelectedItems.Clear();
						//
						// If nothing else was changed on the form, 
						// re-set the IsDirty flag
						if (!this._isDirtyTemp)
						{
							this.IsDirty = false;
						}
						this.ReleaseLocks(lockGuid);
					}
					catch (med.vbecs.Common.RowVersionException)
					{
						this.btnInvalidateAntigenTyping.RowVersionException = true;		//CR2077
						this.ReleaseLocks(lockGuid);
						GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					}
				}
			}
		}

		/// <summary>
		/// Displays a message as user hovers over the button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnInvalidateAntigenTyping_MouseHover(object sender, System.EventArgs e)
		{
			// **** 508 Compliance ***
			if ( this.lvAntigenTyping.Items != null && this.lvAntigenTyping.Items.Count > 0 )
			{
				if (this.lvAntigenTyping.SelectedIndices.Count > 0)
				{
					string inactivateComment = String.Empty;
					if (this.cmbAntigenInactivateComment.SelectedIndex > 0)
					{
						if (this.cmbAntigenInactivateComment.Text.Trim().ToUpper() == "OTHER")
						{
							inactivateComment = this.txtAntigenInactivateComment.Text;
						}
						else
						{
							inactivateComment = string.Concat(this.cmbAntigenInactivateComment.Text, this.txtAntigenInactivateComment.Text);
						}
					}
					else
					{
						inactivateComment = this.txtAntigenInactivateComment.Text;
					}
					if (inactivateComment.Length == 0)
					{
						this.btnInvalidateAntigenTyping.SetToolTip(Common.StrRes.Tooltips.Common.EnterAComment().ResString);
					}
					else
					{
						this.btnInvalidateAntigenTyping.SetToolTip(String.Empty);
					}
				}
				else
				{
					this.btnInvalidateAntigenTyping.SetToolTip(Common.StrRes.Tooltips.UC070.SelectTest().ResString);
				}
			}
			else
			{
				// **** 508 Compliance ***
				this.btnInvalidateAntigenTyping.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
		}

		/// <summary>
		/// When the user clicks the "Inactivate Unit" button
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnInactivateUnit_Click(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() )
			{
				try
				{
					string errorMessage = BloodUnitInactivate.IsUnitEligibleForInactivation(this._bloodUnit);
					if(errorMessage.Equals(string.Empty))
					{
						string inactivateComment = String.Empty;
						DlgOverrideComment dlg = new med.vbecs.GUI.DlgOverrideComment("Comment required ", Common.StrRes.ConfMsg.UC070.InactivateUnit().ResString, "UY");

                        dlg.ShowDialogFromLockedParent(this, false);

						if (dlg.DialogResult == DialogResult.OK)
						{
							inactivateComment = dlg.Comment;
						}
						else
						{
							return;
						}
						// BR_70.11
						if (inactivateComment.Length == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC070.InactivationCommentRequired());
						}
						Common.WorkloadProcessID inactivationWorkload = Common.WorkloadProcessID.Unknown;
						//
						BloodUnitInactivate.InactivateUnit(this._bloodUnit, inactivateComment, Common.UpdateFunction.UC070FrmEditUnitProcessing, this._bloodUnitAntigens, ref inactivationWorkload);

						//CR 1441, 2173
						System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) inactivationWorkload);
						if(dt!= null && inactivationWorkload != Common.WorkloadProcessID.Unknown)
						{
							if(dt.Rows.Count == 0)
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
							}
						}

						this.bloodUnitSelectorVertical1_ClearBtnClick(sender, e);
						this.bloodUnitSelectorVertical1.DisplayBloodUnit("", "");
						this.UnlockAllRecords();
						// Set focus so they can go another round
						this.bloodUnitSelectorVertical1.txtUnitID.Focus();
						//
						this.IsDirty = false;
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(errorMessage));
					}
				}
				catch(med.vbecs.Common.RowVersionException)
				{
					this.btnInactivateUnit.RowVersionException = true;		//CR2077
					GuiMessenger.ShowMessageBox(StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				}
			}
		}

		#endregion

		#region Other Events
		
		/// <summary>
		/// Event attached to the Valid/Invalid/IsDirtyChanged events of the BloodUnit object
		/// Enables the OK button if the user is valid.
		/// Update: Ok button should only be enabled when the 
		///			user actually changes something.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnValid(object sender, System.EventArgs e)
		{
			btnOK.SetToolTip( this._bloodUnit.IsValid ? Common.StrRes.Tooltips.Common.OKToSave().ResString : this._bloodUnit.GetBrokenRulesMessage(this.Name) );
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmEditUnitProcessing_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnInvalidateABORhConfirmation.EnabledButton 
				&& this.tabEditUnit.SelectedIndex == 1 
				&& this.lvABORhConfirmation.SelectedIndices.Count == 0
				&& this.lvABORhConfirmation.Items != null
				&& this.lvABORhConfirmation.Items.Count > 0
				|| !this.btnInvalidateAntigenTyping.EnabledButton 
				&& this.tabEditUnit.SelectedIndex == 2 
				&& this.lvAntigenTyping.SelectedIndices.Count == 0 
				&& this.lvAntigenTyping.Items != null
				&& this.lvAntigenTyping.Items.Count > 0 )
			{
				textToSpeak = Common.StrRes.Tooltips.UC070.SelectTest().ResString;
			}
			else if ( !this.btnInvalidateABORhConfirmation.EnabledButton 
				&& this.tabEditUnit.SelectedIndex == 1 
				&& this.lvABORhConfirmation.SelectedIndices.Count == 0
				&& this.lvABORhConfirmation.Items != null
				&& this.lvABORhConfirmation.Items.Count > 0
				|| !this.btnInvalidateAntigenTyping.EnabledButton 
				&& this.tabEditUnit.SelectedIndex == 2 
				&& this.lvAntigenTyping.SelectedIndices.Count == 0 
				&& this.lvAntigenTyping.Items != null
				&& this.lvAntigenTyping.Items.Count > 0 )
			{
				textToSpeak = Common.StrRes.Tooltips.Common.EnterAComment().ResString;
			}
			else if ( !this.btnOK.EnabledButton && this._bloodUnit == null )
			{
				if ( this.bloodUnitSelectorVertical1.txtUnitID == null ||
					this.bloodUnitSelectorVertical1.txtUnitID.Text == string.Empty )
				{
					textToSpeak = "Select Unit ID ";
				}
				if ( this.bloodUnitSelectorVertical1.txtProductID == null ||
					this.bloodUnitSelectorVertical1.txtProductID.Text == string.Empty )
				{
					textToSpeak = textToSpeak.Length > 0 ? string.Concat(textToSpeak, " and Product ") : "Select Product ";
				}
				//
				textToSpeak = textToSpeak.Length > 0 ? string.Concat(textToSpeak, " to continue.") : string.Empty;
			}	
			else if ( !this.btnOK.EnabledButton && !this.IsDirty )
			{
				textToSpeak = Common.StrRes.Tooltips.Common.NoChangesToSave().ResString;
			}
			// Also get the error provider messages for the BloodUnitSelector control
			textToSpeak = string.Concat(textToSpeak, "\n", this.bloodUnitSelectorVertical1.GetErrorMessages());
			//
			this.SpeakMessage( textToSpeak );
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton && this._bloodUnit == null )
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectBloodUnit().ResString);
			}	
			else if ( !this.btnOK.EnabledButton && !this.IsDirty )
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}	
			else if ( !this.btnOK.EnabledButton && !this._bloodUnit.IsValid )
			{
				this.btnOK.SetToolTip(this._bloodUnit.GetBrokenRulesMessage(this.Name));
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
		}

		#endregion

		#endregion

		#region Methods

		/// <summary>
		/// Checks whether OK should be enabled
		/// </summary>
		private void EnableOkButton()
		{
			this.btnOK.EnabledButton = (BrokenFormRulesCount == 0);
			if (BrokenFormRulesCount == 0) this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString); // **** 508 Compliance ***
		}


		/// <summary>
		/// Set initial values
		/// BR_70.02
		/// </summary>
		/// <returns></returns>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this._isLoading = true;
			this._isClearing = false;
			//
			this.vbecsLogo1.Title = "Edit Unit Information";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC070.FrmEditUnitProcessing());
			this.SetThisHelpFile(this.btnInactivateUnit, Common.StrRes.HelpFiles.UC070.FrmEditUnitProcessing_Inactivate());
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			this.btnInactivateUnit.Text = "&Inactivate Unit";
			this.btnInactivateUnit.EnabledButton = false;
			this.btnInvalidateABORhConfirmation.Text = "Invalidate &Test";
			this.btnInvalidateABORhConfirmation.EnabledButton = false;
			this.btnInvalidateAntigenTyping.Text = "Invalidate &Test";
			this.btnInvalidateAntigenTyping.EnabledButton = false;
			this.pageAntigenTyping.Enabled = false;
			this.pageABORhConfirmation.Enabled = false;
			this.pageUnitInformation.Enabled = false;
		

		

			if ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId < (int)Common.UserRoleType.EnhancedTechnologist)
			{
				//Hide the two testing tabs if the user is a level 1
				this.tabEditUnit.TabPages.Remove(this.pageABORhConfirmation);
				this.tabEditUnit.TabPages.Remove(this.pageAntigenTyping);
				this.grpVolume.Enabled = false;
				this.grpRestrictions.Enabled = false;
				this.grpBiohazardous.Enabled = false;
				this.grpRestrictedFor.Enabled = false;
				//BR_70.02
				this.specialTesting1.AllowUpdate = false;
			}
			this.specialTesting1.LoadAntigenList();
			try
			{
				//Testing status list
				this._alTestingStatusList = BOL.TestingStatus.GetTestingStatusLookupList();
				this.cmbTestingStatus.Items.Clear();
				this.cmbTestingStatus.Items.Add("");
				foreach(string sTestingStatus in this._alTestingStatusList)
				{
					int nComma = sTestingStatus.IndexOf(",");
					string sText = sTestingStatus.Substring(nComma + 1); 
					cmbTestingStatus.Items.Add(sText);
				}
				this.cmbAboRhInactivateComment.Items.Add(String.Empty);
				this.cmbAntigenInactivateComment.Items.Add(String.Empty);
				DataTable cannedComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode, "UT");
				foreach (DataRow dr in cannedComments.Rows)
				{
					this.cmbAboRhInactivateComment.Items.Add(dr["CannedCommentText"]);
					this.cmbAntigenInactivateComment.Items.Add(dr["CannedCommentText"]);
				}
				cannedComments.Dispose();
				cannedComments = null;
				this._isLoading = false;
			}
			catch (Exception e)
			{
				this._isLoading = false;
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.TestingStatusListError(e.Message));
			}
		}

		/// <summary>
		/// Gets a Blood Unit and its tests based on user input and attaches the events.
		/// BR_70.03, BR_70.06, BR_70.07, BR_70.08, BR_70.20
		/// </summary>
		private void GetBloodUnit()
		{
			this._bloodUnit = this.bloodUnitSelectorVertical1.SelectedBloodUnit;
						
			//Check the unit for pending transfer status
			if (this._bloodUnit.PendingTransferIndicator)
			{
				throw new BOL.BusinessObjectException(string.Format("Unit {0}, {1} is pending transfer and cannot be selected.",this._bloodUnit.EyeReadableUnitId, this._bloodUnit.FullProductCode));
			}

			// Set locks will display any "Lock exists" messages
			if (this.SetLocks(this._bloodUnit.BloodUnitGuid, this._bloodUnit.BloodUnitMedia.BloodUnitMediaGuid, this._bloodUnit.BloodUnitStatus.BloodUnitStatusGuid))
			{
				// Succesfully locked unit, so continue ...
				// BR_70.06
				if (this._bloodUnit.BloodUnitStatus.IsFinal())
				{
					throw(new Exception("Unit has been assigned a final status. Cannot edit/inactivate information."));
				}
				// BR_70.03
				DataTable dtOrders = BOL.OrderedUnit.GetOrderedUnit(this._bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				if (dtOrders.Rows.Count > 0)
				{
					throw(new Exception("Unit currently assigned to a patient. You must release unit from the patient before proceeding."));
				}
				dtOrders.Dispose();
				dtOrders = null;
				// BR_70.07
				DataTable orderedUnits = BOL.OrderedUnit.GetHistoricalOrderedUnits(this._bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				if( (orderedUnits.Rows.Count > 0) && !ThisUser.IsAuthorized( Common.UserRoleType.TraditionalSupervisor ) )
				{
					throw(new Exception("Unit has previous history of patient assignment. You cannot modify this unit."));
				}
				orderedUnits.Dispose();
				orderedUnits = null;
				//
				//
				// Load unit test information, if necessary
				// BR_70.08, BR_70.20
				if ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist)
				{
					this._aboRhConfirmationTests = BOL.BloodUnitTest.GetAboRHConfirmationTests(this._bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
					this._antigenTypingTests = BOL.BloodUnitTest.GetAntigenTypingTests(this._bloodUnit.BloodUnitGuid, Common.LogonUser.LogonUserDivisionCode);
				}	
				// Load antigens if the unit is of the correct
				// component class, otherwise disable the 
				// antigen control
				// BR_1.53
				this._bloodUnitAntigens = new ArrayList();
				switch ( this._bloodUnit.BloodComponentClassId )
				{
					case (int) Common.ComponentClass.RBC: 
					case (int) Common.ComponentClass.WB:
					{
						// Sickle Cell and Antigen Typing is enabled
						this.specialTesting1.SickleCellEnabled = true;
						this.specialTesting1.AntigensEnabled = true;
						//
						DataTable antigens = BOL.BloodUnitAntigen.GetBloodUnitAntigens(_bloodUnit.BloodUnitGuid, _bloodUnit.DivisionCode);	
						//
						foreach(DataRow row in antigens.Rows)
						{
							this._bloodUnitAntigens.Add(new BOL.BloodUnitAntigen(row));
						}
						//
						break;
					}
					default:
					{
						// Sickle Cell and Antigen Typing is disabled
						// for all other component classes
						this.specialTesting1.SickleCellEnabled = false;
						this.specialTesting1.AntigensEnabled = false;
						break;
					}
				}
				//
				_bloodUnit.SetInitialBrokenRules(this.Name);
				//
				this._bloodUnit.Invalid += new System.EventHandler(this.OnValid);
				this._bloodUnit.Valid += new System.EventHandler(this.OnValid);
				// setting the event to fire the setdirtyflag function
				this._bloodUnit.Invalid += new System.EventHandler(this.SetDirtyFlag);
				//
				// setting the event to fire the setdirtyflag function
				this.updDiscardedPlasmaVolume.TextChanged += new System.EventHandler(this.SetDirtyFlag);
				this.updVolume.TextChanged += new System.EventHandler(this.SetDirtyFlag);
				this.specialTesting1.IsDirtyChanged += new System.EventHandler(this.SetDirtyFlag);
				this.cbBiohazardous.CheckedChanged += new System.EventHandler(this.SetDirtyFlag);
				this.txtAboRhInactivateComment.TextChanged += new System.EventHandler(this.SetDirtyFlag);
				this.cmbAboRhInactivateComment.SelectedIndexChanged += new System.EventHandler(this.SetDirtyFlag);
				this.txtAntigenInactivateComment.TextChanged += new System.EventHandler(this.SetDirtyFlag);
				this.cmbAntigenInactivateComment.SelectedIndexChanged += new System.EventHandler(this.SetDirtyFlag);
				// 
				// Comments for ABO/Rh and Antigen Typing are
				// initially disabled
				this.cmbAboRhInactivateComment.Enabled = false;
				this.txtAboRhInactivateComment.ReadOnly = true;
				this.cmbAntigenInactivateComment.Enabled = false;
				this.txtAntigenInactivateComment.ReadOnly = true;
				//
				// Enable OK button unless the unit is invalid
				this.OnValid(this, System.EventArgs.Empty);
				//
				this.specialTesting1.BloodUnitGuid = this._bloodUnit.BloodUnitGuid;
			}
			else
			{
				this.bloodUnitSelectorVertical1.txtUnitID.Text = string.Empty;
				this.bloodUnitSelectorVertical1.txtProductID.Text = string.Empty;
				this.bloodUnitSelectorVertical1.txtUnitID.Focus();
				this.bloodUnitSelectorVertical1.ClearBloodUnit();
				this.ClearUnitInfo();
			}
		}

		/// <summary>
		/// Update the form with/without values from the working _bloodunit object
		/// BR_70.19
		/// </summary>
		/// <param name="populateValues">A boolean indicating whether to populate the data on the screen</param>
		private void SetControlData(bool populateValues)
		{
			//BR_70.19
			if (populateValues)
			{
				//Populate screen with values
				PopulateUnitInformation();
				if ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist)
				{
					//We only need to populate test information
					//if the user is VBECS security level 2 or higher
					PopulateAboRhConfirmation();
					PopulateAntigenTyping();
				}
			}
		}

		/// <summary>
		/// Clear out the selected item details from the Abo/Rh Confirmation tab
		/// </summary>
		private void ClearAboRhConfirmationTab()
		{
			this.txtABOComment.Text = "";
			this.txtABOInterpretation.Text = "";
			this.txtAboRhInactivateComment.Text = "";
			this.txtAntiA.Text = "";
			this.txtAntiAB.Text = "";
			this.txtAntiB.Text = "";
			this.txtAntiD.Text = "";
			this.txtDControl.Text = "";
			this.txtRhComment.Text = "";
			this.txtRhInterpretation.Text = "";
			this.cmbAboRhInactivateComment.SelectedIndex = 0;
			this.btnInvalidateABORhConfirmation.EnabledButton = false;
		}

		/// <summary>
		/// Clear out the selected item (and its details) from the Antigen Typing tab
		/// </summary>
		private void ClearAntigenTypingTab()
		{
			this.txt37C.Text = "";
			this.txtAHG.Text = "";
			this.txtAntigenInactivateComment.Text = "";
			this.txtAntigenTypingComment.Text = "";
			this.txtAntigenTypingInterpretation.Text = "";
			this.txtAntiserum.Text = "";
			this.txtCC.Text = "";
			this.txtIS.Text = "";
			this.txtLotNumber.Text = "";
			this.txtRT.Text = "";
			this.cmbAntigenInactivateComment.SelectedIndex = 0;
			this.btnInvalidateAntigenTyping.EnabledButton = false;
		}

		/// <summary>
		/// When the user clicks the clear button or searches for new unit
		/// </summary>
		private void ClearUnitInfo()
		{
			// clear error provider
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, string.Empty); // **** 508 Compliance ***
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtUnitID, string.Empty); // **** 508 Compliance ***
			//
			this.SetControlData(false);
			this.SetControlState(false);
			this.btnOK.EnabledButton = false;
			//
			// clear ABO/Rh and Antigen test tabs
			//
			this.lvABORhConfirmation.Items.Clear();
			if(this._aboRhConfirmationTests != null)
			{
				this._aboRhConfirmationTests.Clear();
				this._aboRhConfirmationTests = null;
				ClearAboRhConfirmationTab();
			}
			//
			this.lvAntigenTyping.Items.Clear();
			if(this._antigenTypingTests != null)
			{
				this._antigenTypingTests.Clear();
				this._antigenTypingTests = null;
				ClearAntigenTypingTab();
			}
			//
			// Clearing the contents of the paged.
			this.IsDirty = false;
			//
			// Removing events if there had already been a blood unit selected.
			if(this._bloodUnit != null)
			{
				this._bloodUnit.Invalid -= new System.EventHandler(this.SetDirtyFlag);
				this.UnlockAllRecords();
				this._bloodUnit = null;
				this.updDiscardedPlasmaVolume.TextChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.updVolume.TextChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.specialTesting1.IsDirtyChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.cbBiohazardous.CheckedChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.txtAboRhInactivateComment.TextChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.cmbAboRhInactivateComment.SelectedIndexChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.txtAntigenInactivateComment.TextChanged -= new System.EventHandler(this.SetDirtyFlag);
				this.cmbAntigenInactivateComment.SelectedIndexChanged -= new System.EventHandler(this.SetDirtyFlag);
			}
			//
			this.specialTesting1.ResetSpecialTesting();
			//
			this.txtDonationType.Text = string.Empty;
			//
			this.cmbTestingStatus.Text = string.Empty;
			//
			this.cbBiohazardous.Checked = false;
			//
			// Reset the volume
			this.updDiscardedPlasmaVolume.Value = 0;
			this.updVolume.Value = 0;
			//
			this.bloodUnitSelectorVertical1.ClearBloodUnit();
			//
			this.txtRestrictedPatient.Text = string.Empty;
			//
			// Clear out any invalid antigens
			this._invalidAntigens.Clear();
		}

		/// <summary>
		/// Populate the Unit Information page
		/// Implements BR_12.13, BR_70.14
		/// </summary>
		private void PopulateUnitInformation()
		{
			try
			{
				this.updDiscardedPlasmaVolume.Value = (int)this._bloodUnit.DiscardedPlasmaVolume;
			}
			catch(FormatException)
			{
				this.updDiscardedPlasmaVolume.Value = this.updDiscardedPlasmaVolume.Minimum;
			}
			if ((int)this._bloodUnit.DiscardedPlasmaVolume == 0)
			{
				this.updDiscardedPlasmaVolume.ReadOnly = true;
			}
			else
			{
				this.updDiscardedPlasmaVolume.ReadOnly = false; //508 compliance
			}
			try
			{
				this.updVolume.Value = (int)this._bloodUnit.OriginalVolume;
			}
			catch(FormatException)
			{
				this.updVolume.Value = this.updVolume.Minimum;
			}
			// 
			this.txtDonationType.Text = this._bloodUnit.DonationType.DonationTypeText;
			if (this._bloodUnit.BloodUnitMedia.TestingStatusId == 0)
			{
				this.cmbTestingStatus.SelectedIndex = 0;
			}
			else
			{
				int counter = 0;
				while((counter < cmbTestingStatus.Items.Count) && (GetTestingStatusText(this._bloodUnit.BloodUnitMedia.TestingStatusId) != this.cmbTestingStatus.Items[counter].ToString()))
				{
					counter++;
				}
				if (counter < cmbTestingStatus.Items.Count)
					this.cmbTestingStatus.SelectedIndex = counter;
				else
					this.cmbTestingStatus.SelectedIndex = 0;
			}
			//
			// BR_70.14
			if (this._bloodUnit.DonationType.DirectedType.Equals("A"))
				this.cmbTestingStatus.Enabled = true;
			else
				this.cmbTestingStatus.Enabled = false;
			//
			// BR_12.13
			if(((this._bloodUnit.DonationType.DonationTypeId == (int) Common.DonationTypeId.ForAutologousUseOnlyBiohazardous ||
				this._bloodUnit.DonationType.DonationTypeId == (int) Common.DonationTypeId.ForDirectedDonorUseOnlyBiohazardous)) ||
				this._bloodUnit.BloodUnitStatus.QuarantineIndicator ||
				this.cmbTestingStatus.SelectedIndex > 1)
			{
				this.cbBiohazardous.Checked = true;
				this.cbBiohazardous.Enabled = false;
			}
			else
			{
				this.cbBiohazardous.Checked = this._bloodUnit.BloodUnitStatus.BiohazardousWarningIndicator;
				this.cbBiohazardous.Enabled = true;
			}
			// 
			this.txtRestrictedPatient.Text = this._bloodUnit.DirectedPatient.DisplayName;
			if (this.txtRestrictedPatient.Text.Trim().Length > 0)
				this.btnSelectPatient.Enabled = true;
			else
				this.btnSelectPatient.Enabled = false;
			this.specialTesting1.DivisionCode = Common.LogonUser.LogonUserDivisionCode;
			this.specialTesting1.BloodUnitGuid = _bloodUnit.BloodUnitGuid;
			//
			// store original test ids
			this._cmvTestOrigTestId = this.specialTesting1.CmvTest.TestResultId;
			this._scTestOrigTestId = this.specialTesting1.SickleCellTest.TestResultId;
		}

		/// <summary>
		/// Populate the Abo/Rh Confirmation page
		/// </summary>
		private void PopulateAboRhConfirmation()
		{
			// Keep track if we are on the next row through the
			// ConfirmationWorklistUnitGuid, which changes with each row
			System.Guid oldGuid = System.Guid.Empty;
			String dateTested = String.Empty;
			String aboInterp = String.Empty;
			String rhInterp = String.Empty;
			int testCounter = 0;
			foreach(BOL.BloodUnitTest buTest in _aboRhConfirmationTests)
			{
				testCounter++;
				// The first time we enter, we need to set the old GUID
				if (oldGuid == System.Guid.Empty)
					oldGuid = buTest.ConfirmationWorklistUnitGuid;
				// If we have arrived at the new row, then write out the old
				// row and change the guid pointer
				if ((buTest.ConfirmationWorklistUnitGuid != oldGuid) || (testCounter == _aboRhConfirmationTests.Count))
				{
					if (testCounter == _aboRhConfirmationTests.Count)
					{
						// For an Abo Interp, get the result and the date tested
						if (buTest.BloodTestTypeObj.BloodTestTypeId == 18)
						{
							dateTested = Common.VBECSDateTime.FormatDateTimeString(buTest.TestDate);
							aboInterp = buTest.TestResultId;
						}
						// For an Rh Interp, get the result
						if (buTest.BloodTestTypeObj.BloodTestTypeId == 21)
							rhInterp = buTest.TestResultId;
					}
					string[] subItems = 
					{
						dateTested, 
						aboInterp,
						rhInterp,
						oldGuid.ToString()
					};
					ListViewItem newItem = new ListViewItem(subItems);
					this.lvABORhConfirmation.Items.Add(newItem);
					oldGuid = buTest.ConfirmationWorklistUnitGuid;
				}
				// For an Abo Interp, get the result and the date tested
				if (buTest.BloodTestTypeObj.BloodTestTypeId == 18)
				{
					dateTested = Common.VBECSDateTime.FormatDateTimeString(buTest.TestDate);
					aboInterp = buTest.TestResultId;
				}
				// For an Rh Interp, get the result
				if (buTest.BloodTestTypeObj.BloodTestTypeId == 21)
					rhInterp = buTest.TestResultId;
			}
		}

		/// <summary>
		/// Populate the Antigen Typing page
		/// </summary>
		private void PopulateAntigenTyping()
		{
			// Keep track if we are on the next row through the
			// AntiseraWorklistTypingGuid, which changes with each row
			System.Guid oldGuid = System.Guid.Empty;
			String dateTested = String.Empty;
			String specificity = String.Empty;
			String interpretation = String.Empty;
			String orderableTestId = String.Empty;
			int testCounter = 0;
			foreach(BOL.BloodUnitTest buTest in _antigenTypingTests)
			{
				testCounter++;
				// The first time we enter, we need to set the old GUID
				if (oldGuid == System.Guid.Empty)
					oldGuid = buTest.AntiseraWorklistTypingGuid;
				// If we have arrived at the new row, then write out the old
				// row and change the guid pointer
				if ((buTest.AntiseraWorklistTypingGuid != oldGuid) || (testCounter == _antigenTypingTests.Count))
				{
					if ((testCounter == _antigenTypingTests.Count) && (buTest.BloodTestTypeObj.BloodTestName.IndexOf("Interp") != -1))
					{
						specificity = buTest.Specificity;
						dateTested = Common.VBECSDateTime.FormatDateTimeString(buTest.TestDate);
						interpretation = buTest.TestResultId;
						orderableTestId = buTest.OrderableTestId.ToString();
					}
					string[] subItems = 
					{
						specificity, 
						dateTested,
						interpretation,
						oldGuid.ToString(),
						orderableTestId
					};
					ListViewItem newItem = new ListViewItem(subItems);
					newItem.Tag = buTest.AntiseraWorklistTypingGuid;
					this.lvAntigenTyping.Items.Add(newItem);
					oldGuid = buTest.AntiseraWorklistTypingGuid;
				}
				// For an Antigen Interp, get the result and the date tested
				if (buTest.BloodTestTypeObj.BloodTestName.IndexOf("Interp") != -1)
				{
					specificity = buTest.Specificity;
					dateTested = Common.VBECSDateTime.FormatDateTimeString(buTest.TestDate);
					interpretation = buTest.TestResultId;
					orderableTestId = buTest.OrderableTestId.ToString();
				}
			}
		}

		/// <summary>
		/// Set control state on the form based on boolean being passed in
		/// Implements BR_70.08, BR_70.11, BR_70.20
		/// </summary>
		/// <param name="enabled">Are the controls to be enabled or not</param>
		private void SetControlState(bool enabled)
		{
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = enabled;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = enabled;

			// BR_70.11
			if ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist)
				this.btnInactivateUnit.EnabledButton = enabled;
			// BR_70.08, BR_70.20
			if (enabled)
			{
				this.pageUnitInformation.Enabled = true;

				// retrieve the correct value for the sickle
				// cell test that was erased in the previous step

				// Enable all pages and controls for users lvl 2 and above
				if ((int)ThisUser.CurrentDivisionRole.Role.UserRoleId >= (int)Common.UserRoleType.EnhancedTechnologist)
				{
					this.pageAntigenTyping.Enabled = true;
					this.pageABORhConfirmation.Enabled = true;
					this.btnInactivateUnit.Enabled = true;
				}
					// Only enable certain controls for users level 1
				else
				{
					specialTesting1.Enabled = true;
					// You can only add from null - disable previously
					// checked fields, only enable empty ones
					if (this._bloodUnit.CmvNegative)
						specialTesting1.CmvEnabled = false;
					if (this._bloodUnit.SickleCellNegative)
						specialTesting1.SickleCellEnabled = false;
				}
			}
			else
			{
				this.pageAntigenTyping.Enabled = false;
				this.pageABORhConfirmation.Enabled = false;
				this.btnInactivateUnit.Enabled = false;
				this.pageUnitInformation.Enabled = false;
				this.btnInvalidateABORhConfirmation.EnabledButton = false;
				this.btnInvalidateAntigenTyping.EnabledButton = false;
			}
		}

		/// <summary>
		/// Get the testing status ID from the testing status text
		/// </summary>
		/// <param name="testingStatusText"></param>
		/// <returns></returns>
		private int GetTestingStatusID(string testingStatusText)
		{	
			int nRetVal = 0;		
			foreach(string sTestingStatus in this._alTestingStatusList)
			{
				int nComma = sTestingStatus.IndexOf(",");
				string sID = sTestingStatus.Substring(0, nComma); 
				string sText = sTestingStatus.Substring(nComma + 1); 
				if(sText == testingStatusText)
				{
					nRetVal = System.Convert.ToInt32(sID);
					return nRetVal;
				}
			}
			return nRetVal;
		}

		/// <summary>
		/// Get the testing status text from the testing status ID
		/// </summary>
		/// <param name="testingStatusID"></param>
		/// <returns></returns>
		private string GetTestingStatusText(int testingStatusID)
		{
			string sText = String.Empty;
			foreach(string sTestingStatus in this._alTestingStatusList)
			{
				int nComma = sTestingStatus.IndexOf(",");
				string sID = sTestingStatus.Substring(0, nComma); 
				sText = sTestingStatus.Substring(nComma + 1); 
				if(System.Convert.ToInt32(sID) == testingStatusID)
				{
					return sText;
				}
			}	
			return sText;
		}

		private void HandlecmbTestingStatusChange()
		{
			//BR_70.16
			Common.TestingStatus testingStatus = (Common.TestingStatus) GetTestingStatusID(this.cmbTestingStatus.SelectedItem.ToString());
			switch (testingStatus)
			{
				case (Common.TestingStatus.Positive):
					this.cbBiohazardous.Checked = true;
					this.cbBiohazardous.Enabled = false;
					break;
				case (Common.TestingStatus.NotFullyTested):
					this.cbBiohazardous.Checked = true;
					this.cbBiohazardous.Enabled = false;
					break;
				default:
					this.cbBiohazardous.Enabled = true;
					break;
			} 
		}

		#endregion
	}
}

